'.-------+----------+----------- [IMDB] ----------+--------------------:
'|                           IMDB v1.10 by TuS                         |
':-------+----------+----------+-----------------+---------------------:
Option Explicit 

'Import Configuration
Import ("Imdb.Config")

'Make sure constants in Imdb.config are correctlly defined
If TypeName(RAIDENFTPD_PATH) <> "String" _
    Or TypeName(USE_PROXY) <> "Boolean" Or TypeName(PROXY_URL) <> "String" Or TypeName(PROXY_USER) <> "String" Or TypeName(PROXY_PASS) <> "String" _
    Or TypeName(IMDB_ALLOWED_VFS) <> "String" Or TypeName(IMDB_DENIED_VFS) <> "String" _
    Or TypeName(IMDB_EVENT_ALLOWED_VFS) <> "String" Or TypeName(IMDB_EVENT_DENIED_VFS) <> "String" Or TypeName(IMDB_OPS_ONLY) <> "Boolean" _
    Or TypeName(IMDB_ENABLE_BAR) <> "Boolean" Or TypeName(IMDB_BAR_TYPE) <> "String" _
	Or TypeName(IMDB_BAR) <> "String" Or TypeName(IMDB_TV_BAR) <> "String" Or TypeName(DEL_IMDB_BAR) <> "String" Or TypeName(DEL_IMDB_TV_BAR) <> "String" _
	Or TypeName(IMDB_BAR_CHOWN) <> "Boolean" Or TypeName(IMDB_BAR_MODE) <> "Integer" Or TypeName(IMDB_TAG_SPACE) <> "Boolean" _
	Or TypeName(IMDB_POSTER_DOWNLOAD) <> "Boolean" Or TypeName(IMDB_POSTER_SIZE) <> "Integer" Or TypeName(IMDB_POSTER_NAME) <> "String" _
	Or TypeName(IMDB_FILE_SAVE) <> "Boolean" Or TypeName(IMDB_FILE_NAME) <> "String" Or TypeName(IMDB_FILE_ADD_DATE) <> "Boolean" _
	Or TypeName(IMDB_FILE_CHOWN) <> "Boolean" Or TypeName(IMDB_FILE_MODE) <> "Integer" _
	Or TypeName(IMDB_GET_EPISODE_ID) <> "Boolean" Or TypeName(IMDB_USE_ORIGINAL_TITLE) <> "Boolean" Or TypeName(IMDB_PRESERVE_DATE) <> "Boolean" _
	Or TypeName(DIR_IGNORELIST) <> "String" Or TypeName(IMDB_ENABLE_OFFICIAL_LINKS) <> "Boolean" _
	Or TypeName(SCENEVIEW) <> "Boolean" Or TypeName(WIDTH) <> "Integer" _
	Or TypeName(SCENEHEADER) <> "String" Or TypeName(SCENESEPARATOR) <> "String" Or TypeName(SCENETAIL) <> "String" _
	Or TypeName(NORMALHEADER) <> "String" Or TypeName(NORMALSEPARATOR) <> "String" Or TypeName(NORMALTAIL) <> "String" _
	Or TypeName(EVENTLOG) <> "Integer" Or TypeName(FILELOG) <> "Integer" Or TypeName(NUMBEROFLOGS) <> "Integer" Then
	WScript.echo "One or more required constants is not defined. Please see " _
	& "readme.txt for installation"
	WScript.quit
End If

'*********************************************************************************
'*********************************************************************************
'       DO NOT CHANGE THESE CONSTANTS UNLESS YOU KNOW WHAT YOU ARE DOING
'*********************************************************************************
Const APPNAME       = "TuS IMDB"
Const APPVERMAJOR   = "1"
Const APPVERMINOR   = "1"
Const FORREADING    = 1
Const FORWRITING    = 2
Const FORAPPENDING  = 8
Const SUCCESS       = 0
Const ERRORL        = 1
Const WARNING       = 2
Const INFORMATION   = 4
Const ABORT         = "Script aborted with error(s). To determine cause, see logged information"
Const SITECMD       = "imdb"

'Script Root folder
Dim SCRIPTPATH : SCRIPTPATH = Left(WScript.ScriptFullName, InStrRev(WScript.ScriptFullName,"\")-1)
Dim SCRIPTNAME : SCRIPTNAME = Left(WScript.ScriptName, InStrRev(WScript.ScriptName,".")-1)
'Script Default parameters
Dim DEF_IMDB_ID         : DEF_IMDB_ID          = vbNullString  
Dim DEF_POSTER_DOWNLOAD : DEF_POSTER_DOWNLOAD  = IMDB_POSTER_DOWNLOAD
Dim DEF_POSTER_SIZE     : DEF_POSTER_SIZE      = IMDB_POSTER_SIZE
Dim DEF_FILE_SAVE       : DEF_FILE_SAVE        = IMDB_FILE_SAVE
Dim DEF_DEBUG           : DEF_DEBUG            = False
'*********************************************************************************
'012345678901234567890123456789012345678901234567890123456789012345678901234567891

'#################################################################################
'	Main Entry Point
'#################################################################################
Dim currentSub : currentSub = "Main Code"

Dim iCnt, iCnt2
Dim cmdGCID,cmdLEVEL, cmdSERVER, cmdUSER, cmdUSERGRP, cmdSITECMD, cmdEVENT, cmdVIRTUALPATH, cmdITEM, cmdOPTIONS, cmdIMDBid, cmdTYPE
Dim oArgs : Set oArgs = WScript.Arguments

Dim tStartTime,tEndTime

Const DEBUG_CLASS_EVENTS = False
Const FIRE_CLASS_EVENTS  = False

tStartTime = Now
'#-------------------------------------------------------------------------------#
'Load the framwork
'#-------------------------------------------------------------------------------#
'Init the Logger
Dim UserLog : Set UserLog = New UserLogClass
UserLog.LogEvent SUCCESS, "*** " & APPNAME & " " & APPVERMAJOR & "." & APPVERMINOR & " ***"
'Init the Helper
Dim Helper : Set Helper = New HelperClass
'Start the logger
UserLog.Start
'Init the Classes
Dim IMDB          : Set IMDB          = New IMDBClass
Dim RaidenVFSFile : Set RaidenVFSFile = New RaidenVFSFileClass
Dim RaidenOutFile : Set RaidenOutFile = New RaidenOutFileClass
Dim CmdProcessor  : Set CmdProcessor  = New CmdProcessorClass
UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
UserLog.LogEvent SUCCESS, "[Main Code] Script Started"
'#-------------------------------------------------------------------------------#
'Simple verification that the FTPD process is initiating the command in a way we expect
If oArgs.Count <= 7 Then
	UserLog.LogEvent ERRORL, "[" & currentSub & "] FTPD or this installation has been tampered with. This command needs at least SEVEN arguments to run"
	WScript.Quit
End If

'Assign Main Parameters
For iCnt = 0 To oArgs.Count -1 
	UserLog.LogEvent INFORMATION, "[" & currentSub & "] Argument#" & iCnt+1 & ", Value=" & oArgs(iCnt)
	
	Select Case iCnt
		Case 0
			cmdGCID = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] GCID=" & cmdGCID
		Case 1
			cmdLEVEL = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] LEVEL=" & cmdLEVEL
		Case 2
			cmdSERVER = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] SERVER=" & cmdSERVER
		Case 3
			cmdUSER = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] USER=" & cmdUSER
		Case 4
			cmdUSERGRP = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] USERGRP=" & cmdUSERGRP
		Case 5
			cmdVIRTUALPATH = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] VIRTUALPATH=" & cmdVIRTUALPATH
		Case 6
			cmdSITECMD = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] SITECOMMAND=" & cmdSITECMD
		Case 7
			cmdEVENT = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] CMDEVENT=" & cmdEVENT
		Case 8
			cmdITEM = Helper.CleanString(Right(oArgs(iCnt), Len(oArgs(iCnt)) - InStrRev(oArgs(iCnt),"/")))
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] CMDITEM=" & cmdITEM
		Case 9
			'get the options if any	
			Dim IOptionStart : IOptionStart = 6
			ReDim cmdOPTIONS(oArgs.Count - iCnt - 1)
			For iCnt2 = 0 To (oArgs.Count - iCnt - 1)
				cmdOPTIONS(iCnt2) = LCase(oArgs(iCnt + iCnt2))
			Next
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] OPTIONS=" & Join(cmdOPTIONS," ")
	End Select
Next	

'Assign Parameters for FTPD Events
Select Case LCase(cmdSITECMD)
	Case "imdb"
		cmdTYPE = "user"
		'should be all set allready
	Case "newdir"
		cmdTYPE = "event"
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] NEWDIR FTPD Event Detected"
	    cmdVIRTUALPATH = Helper.CleanString(Left(oArgs(5), InStrRev(oArgs(5),"/") -1))
		cmdITEM = Helper.CleanString(Right(oArgs(5), Len(oArgs(5)) - InStrRev(oArgs(5),"/")))
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Modified CMDVIRTUALPATH=" & cmdVIRTUALPATH
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Modified CMDITEM=" & cmdITEM
	Case "fileuploaded"
		cmdTYPE = "event"
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] FileUploaded FTPD Event Detected"
		If (Helper.CleanString(Right(oArgs(5), Len(oArgs(5)) - InStrRev(oArgs(5),"."))) = "nfo") Then
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Nfo file detected."
			cmdVIRTUALPATH = Helper.CleanString(Left(oArgs(5), InStrRev(oArgs(5),"/") -1))
			cmdITEM = Helper.CleanString(Right(cmdVIRTUALPATH, Len(cmdVIRTUALPATH) - InStrRev(cmdVIRTUALPATH,"/")))
			cmdVIRTUALPATH = Left(cmdVIRTUALPATH, InStrRev(cmdVIRTUALPATH,"/") -1)
			
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Modified CMDVIRTUALPATH=" & cmdVIRTUALPATH
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Modified CMDITEM=" & cmdITEM
		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Not a Nfo file. Aborting execution"
			WScript.Quit
		End If
	Case Else
		UserLog.LogEvent ERRORL, "[" & currentSub & "] Unknown Command: " &  cmdSITECMD & " Detected. Aborting execution"
		WScript.Quit
End Select

UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
'#-------------------------------------------------------------------------------#
' Assign Class Properties (This is the working Context)
'#-------------------------------------------------------------------------------#
RaidenOutFile.GCID 			= cmdGCID
RaidenOutFile.Server		= cmdSERVER
RaidenOutFile.Path			= RAIDENFTPD_PATH
RaidenOutFile.SceneView 	= SCENEVIEW
RaidenOutFile.Width			= WIDTH

RaidenVFSFile.Server		= cmdSERVER
RaidenVFSFile.Path			= RAIDENFTPD_PATH
'#-------------------------------------------------------------------------------#

'load the VFS File
RaidenVFSFile.Load
'Dispatch the command
CmdProcessor.CommandDispatcher

UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
UserLog.LogEvent SUCCESS, "[Main Code] Script Completed"
UserLog.DelLog

'#################################################################################
'	Main Exit Point
'#################################################################################

'#################################################################################
' Class Wrapper for Http
'#################################################################################
Class HTTPClass
	'Class vars
	public serverXMLHttp, ostream
	public c_iStatus, c_sStatus, c_sProxyURL, c_sProxyUser, c_sProxyPassword
	
	'Function vars
	Private currentSub
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		Set serverXMLHttp 	= CreateObject("msxml2.serverxmlhttp.6.0")
		Set ostream 		= CreateObject("adodb.stream")
	    c_sProxyURL			= vbnullstring
	    c_sProxyUser		= vbnullstring
	    c_sProxyPassword	= vbNullString
	    c_iStatus			= 0
	    c_sStatus			= vbNullString	  
	    'set the proxy data
	    SetProxy PROXY_URL,PROXY_USER,PROXY_PASS  
	End Sub
	Private Sub Class_Terminate
		Set serverXMLHttp 	= Nothing
		Set ostream			= Nothing 
	End Sub
	'#---------------------------------------------------------------------------#
	Public Property Get Status()
		Status = c_iStatus
	End Property
	Private Property Let Status(iStatus)
		If (VarType(iStatus) = vblong) Then
			c_iStatus = iStatus
		End If 
	End Property
	
	Public Property Get StatusText()
		StatusText = Replace(c_sStatus, vbCrLf,vbNullString )
	End Property
	Private Property Let StatusText(sStatus)
		If (VarType(sStatus) = vbstring) Then
			c_sStatus = sStatus
		End If 
	End Property
	
	Public Property Get ProxyURL()
		ProxyURL = c_sProxyURL
	End Property
	Private Property Let ProxyURL(sProxyURL)
		If (VarType(sProxyURL) = vbstring) Then
			c_sProxyURL = sProxyURL
		End If 
	End Property
	
	public Property Get ProxyUser()
		ProxyUser = c_sProxyUser
	End Property
	Private Property Let ProxyUser(sProxyUser)
		If (VarType(sProxyUser) = vbstring) Then
			c_sProxyUser = sProxyUser
		End If 
	End Property
	
	public Property Get ProxyPassword()
		ProxyPassword = c_sProxyPassword
	End Property
	Private Property Let ProxyPassword(sProxyPassword)
		If (VarType(sProxyPassword) = vbstring) Then
			c_sProxyPassword = sProxyPassword
		End If 
	End Property
	'#---------------------------------------------------------------------------#
	
	Private Function SetProxy(sURL,sUser,sPassword)
		'********************************************************************************
		' Puropose 	: Set the Proxy for http 
		' Input    	: string : sURL  : The proxy URL
		'			: string : sUser : The proxy User (Optional)
		'			: string : sPassword : The proxy Password (Optional)
		' Output    : None
		'********************************************************************************
		currentSub = "Class HTTP:SetProxy"
		
		If USE_PROXY = True then
			ProxyURL 		= sURL 
			ProxyUser 		= sUser
			ProxyPassword 	= sPassword
		End If 
	End function
	
	Public Function GetURL(sURL)
		'********************************************************************************
		' Puropose 	: Retreive a http document 
		' Input    	: string : sURL : The URL to retreive
		' Output    : string : The retreived data
		'********************************************************************************
		currentSub = "Class HTTP:GetURL"
		
		On Error Resume Next 
		
		'init status
		Status 	= vbNullString 
		StatusText 	= vbNullString 
		
		If ProxyURL <> vbNullString Then
    		serverXMLHttp.setProxy 2,ProxyURL,vbNullString
    		If ProxyUser <> vbNullString Then
    			With serverXMLHttp
					.open "GET",sURL,False
					.setRequestHeader "User-agent", "Mozilla/5.0"
					.setRequestHeader "Content-Type", "text/xml"
				   	.setProxyCredentials PROXY_USER, PROXY_PASS
				   	.send
				End with
    		Else
				With serverXMLHttp
					.open "GET",sURL,False
					.setRequestHeader "User-agent", "Mozilla/5.0"
					.setRequestHeader "Content-Type", "text/xml"
					.send
				End with 
    		End if
    	Else
    		With serverXMLHttp
    			.setProxy 1,vbNullString,vbNullString
    			.open "GET",sURL,False
    			.setRequestHeader "User-agent", "Mozilla/5.0"
				.setRequestHeader "Content-Type", "text/xml"
				.send 
			End with
    	End if

		If Err.number <> 0 Then
			Status = Err.Number
			StatusText = Err.Description
			GetURL = vbNullString 
			Exit Function
		End If

		'Manage the status
		Status = serverXMLHttp.readyState
		StatusText = "Waiting for Response"
		Do While (serverXMLHttp.readyState <> 4)    
			WScript.Sleep 200 'Waiting response from URL
			Status 	= serverXMLHttp.readyState
		Loop  
		'update the status
		Status 	= serverXMLHttp.status
		StatusText 	= serverXMLHttp.statusText	
		
		'Return the Data
		GetURL 		= serverXMLHttp.responseText
	End Function
	
	Public Function GetURLtoFile(sUrl, sFilePath, bOverwrite)
		'********************************************************************************
		' Puropose 	: Retreive a http file 
		' Input    	: string : sURL : The file URL to retreive
		'           : string : sFilePath : the filepath to save to
		'           : bool   : bOverwrite : force file overwrite
		' Output    : bool   : The result OK = true / ERR = False
		'********************************************************************************
		On Error Resume Next 
		
		If ProxyURL <> vbNullString Then
    		serverXMLHttp.setProxy 2,ProxyURL,vbNullString
    		If ProxyUser <> vbNullString Then
    			With serverXMLHttp
					.open "GET",sURL,False
					.setRequestHeader "User-agent", "Mozilla/5.0"
					.setRequestHeader "Content-Type", "text/xml"
				   	.setProxyCredentials PROXY_USER, PROXY_PASS
				   	.send
				End with
    		Else
				With serverXMLHttp
					.open "GET",sURL,False
					.setRequestHeader "User-agent", "Mozilla/5.0"
					.setRequestHeader "Content-Type", "text/xml"
					.send
				End with 
    		End if
    	Else
    		With serverXMLHttp
    			.setProxy 1,vbNullString,vbNullString
    			.open "GET",sURL,False
    			.setRequestHeader "User-agent", "Mozilla/5.0"
				.setRequestHeader "Content-Type", "text/xml"
				.send 
			End with
    	End if

		If Err.number <> 0 Then
			Status = Err.Number
			StatusText = Err.Description
			GetURLtoFile = False
			Exit Function
		End If

		'Manage the status
		Status = serverXMLHttp.readyState
		StatusText = "Waiting for Response"
		Do While (serverXMLHttp.readyState <> 4)    
			WScript.Sleep 100 'Waiting response from URL
			Status 	= serverXMLHttp.readyState
		Loop  
		'update the status
		Status 	= serverXMLHttp.status
		StatusText 	= serverXMLHttp.statusText	
		
		'Return the Data
		oStream.type=1    'binary
		oStream.mode=3    'read-write
		oStream.open
		oStream.write serverXMLHttp.responsebody
		If bOverwrite <> False Then
			oStream.savetofile sFilePath,2    'save-create-overwrite
		Else
			oStream.savetofile sFilePath,1    'save-create-notExist
		End If 
		ostream.Close
		
		If Err.number <> 0 Then
			Status = Err.Number
			StatusText = Err.Description
			GetURLtoFile = False
			Exit Function
		Else
			GetURLtoFile = True
		End If
	End Function
	
End class

'#################################################################################
' Class Wrapper for IMDB Management
'#################################################################################
Class IMDBClass
	'Class vars
	Public c_bMediaLoaded,c_bEpisodeLoaded, c_bSaveDebugFile
	Public c_simdb_ID, c_simdb_Season, c_simdb_Seasons, c_simdb_Episode, c_simdb_Type, c_simdb_OfficialLink, c_simdb_OfficialLinks, c_simdb_Link, c_simdb_MediaLink, _
	c_simdb_Title, c_simdb_TitleOriginal, c_simdb_Description, c_simdb_StoryLine, c_simdb_Genres, c_simdb_Genre,_
	c_simdb_ReleaseDate, c_simdb_ReleaseYear, c_simdb_Rating, c_simdb_Votes, c_simdb_Top250, c_simdb_TagLine, _
	c_simdb_PosterLink, c_simdb_PosterThumbLink, c_simdb_Directors, c_simdb_Director, c_simdb_Stars, c_simdb_Star, c_simdb_Duration, _
	c_simdb_Country, c_simdb_Countries, c_simdb_MPAA, c_simdb_Budget, c_simdb_Screens
	Public c_simdb_EpisodeTitle, c_simdb_EpisodeAirDate, c_simdb_EpisodeDescription, c_simdb_EpisodeRating, c_simdb_EpisodeLink, c_simdb_EpisodeID
	Public regEx, Matches, Match, RetStr, searchPattern, tmpStr
	
	'Function vars
	public tmp_Type, IMDBData,IMDBTVData, Http, currentSub
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		c_bMediaLoaded		= False
		c_bEpisodeLoaded			= False
		c_bSaveDebugFile 	= False
		Set Http 			= New HttpClass
		Set regEx 			= New RegExp  
		regEx.IgnoreCase 	= True   ' Set case insensitivity.
	    regEx.Global 		= True   ' Set global applicability.
	    regEx.Multiline		= True   ' Set global applicability. 
	End Sub
	Private Sub Class_Terminate
	End Sub
	'#---------------------------------------------------------------------------#
	Public Property Get MediaLoaded()
		MediaLoaded = c_bMediaLoaded
	End Property
	Private Property Let MediaLoaded(bMediaLoaded)
		If (VarType(bMediaLoaded) = vbBoolean) Then
			c_bMediaLoaded = bMediaLoaded
		End If 
	End Property
	
	Public Property Get EpisodeLoaded()
		EpisodeLoaded = c_bEpisodeLoaded
	End Property
	Private Property Let EpisodeLoaded(bEpisodeLoaded)
		If (VarType(bEpisodeLoaded) = vbBoolean) Then
			c_bEpisodeLoaded = bEpisodeLoaded
		End If 
	End Property
	
	Public Property Get SaveDebugFile()
		SaveDebugFile = c_bSaveDebugFile
	End Property
	Public Property Let SaveDebugFile(bSaveDebugFile)
		If (VarType(bSaveDebugFile) = vbBoolean) Then
			c_bSaveDebugFile = bSaveDebugFile
		End If 
	End Property
	
	Public Property Get ID()
		ID = c_simdb_ID
	End Property
	
	Public Property Let ID(simdb_ID)
		If (VarType(simdb_ID) = vbString) Then
			c_bMediaLoaded 			= False
			c_bEpisodeLoaded 			= False
			c_simdb_ID    			= simdb_ID
			c_simdb_Type   			= "Movie"
			IMDBData 				= vbNullString
			IMDBTVData 				= vbNullString 
			c_simdb_Link  			= vbNullString 
			c_simdb_OfficialLink    = vbNullString 
			c_simdb_OfficialLinks   = vbNullString 
			c_simdb_Title 			= vbNullString
			c_simdb_TitleOriginal   = vbNullString
			c_simdb_Description		= vbNullString 
			c_simdb_StoryLine 		= vbNullString
			c_simdb_Genres  		= vbNullString 
			c_simdb_ReleaseDate		= vbNullString 
			c_simdb_ReleaseYear		= vbNullString
			c_simdb_Seasons  		= vbNullString
			c_simdb_Rating 			= vbNullString
			c_simdb_Votes 			= vbNullString
			c_simdb_Screens			= vbnullString
			c_simdb_Stars 			= vbNullString
			c_simdb_Star  			= vbNullString
			c_simdb_TagLine			= vbNullString
			c_simdb_PosterThumbLink	= vbNullString
			c_simdb_PosterLink		= vbNullString
			c_simdb_MediaLink		= vbNullString
			c_simdb_Directors		= vbNullString
			c_simdb_Director		= vbNullString
			c_simdb_Duration		= vbNullString
			c_simdb_Country			= vbNullString
			c_simdb_Countries		= vbNullString
			c_simdb_MPAA			= vbNullString
			c_simdb_Budget			= vbNullString
			c_simdb_Top250			= vbNullString
			c_simdb_EpisodeTitle		= vbNullString
			c_simdb_EpisodeAirDate		= vbNullString
			c_simdb_EpisodeDescription	= vbNullString
			c_simdb_EpisodeRating   	= vbNullString
			c_simdb_EpisodeLink      	= vbNullString
			c_simdb_EpisodeID      	= vbNullString
			GetIMDBData(c_simdb_ID)
		End If 
	End Property
	
	Public Property Get Seasons()
		Seasons = c_simdb_Seasons
	End Property
	
	Public Property Get Season()
		Season = c_simdb_Season
	End Property
	Public Property Let Season(iSeason)
		If (VarType(iSeason) = vbString) Then
			c_simdb_Season = iSeason
		End If 
	End Property
	
	Public Property Get Episode()
		Episode = c_simdb_Episode
	End Property
	Public Property Let Episode(iEpisode)
		If (VarType(iEpisode) = vbString) Then
			c_simdb_Episode = iEpisode
		End If 
	End Property
	
	Public Property Get MediaType()
		MediaType = c_simdb_Type
	End Property
	
	Public Property Get Link()
		Link = c_simdb_Link
	End Property
	
	Public Property Get Title()
		Title = c_simdb_Title
	End Property
	
	Public Property Get TitleOriginal()
		TitleOriginal = c_simdb_TitleOriginal
	End Property
	
	Public Property Get Description()
		Description = c_simdb_Description
	End Property
	
	Public Property Get StoryLine()
		StoryLine = c_simdb_StoryLine
	End Property
	
	Public Property Get Genres()
		Genres = c_simdb_Genres
	End Property
	
	Public Property Get Genre()
		Genre = c_simdb_Genre
	End Property
	
	Public Property Get ReleaseDate()
		ReleaseDate = c_simdb_ReleaseDate
	End Property
	
	Public Property Get ReleaseYear()
		ReleaseYear = c_simdb_ReleaseYear
	End Property
	
	Public Property Get Rating()
		Rating = c_simdb_Rating
	End Property
	
	Public Property Get Votes()
		Votes = c_simdb_Votes
	End Property
	
	Public Property Get Screens()
		Screens = c_simdb_Screens
	End Property
	
	Public Property Get TagLine()
		TagLine = c_simdb_TagLine
	End Property
	
	Public Property Get OfficialLink()
		OfficialLink = c_simdb_OfficialLink
	End Property
	
	Public Property Get OfficialLinks()
		OfficialLinks = c_simdb_OfficialLinks
	End Property
	
	Public Property Get PosterLink()
		PosterLink = c_simdb_PosterLink
	End Property
	
	Public Property Get MediaLink()
		MediaLink = c_simdb_MediaLink
	End Property
	
	Public Property Get PosterThumbLink()
		PosterThumbLink = c_simdb_PosterThumbLink
	End Property
	
	Public Property Get Directors()
		Directors = c_simdb_Directors
	End Property
	
	Public Property Get Director()
		Director = c_simdb_Director
	End Property
	
	Public Property Get Stars()
		Stars = c_simdb_Stars
	End Property
	
	Public Property Get Star()
		Star = c_simdb_Star
	End Property
	
	Public Property Get Duration()
		Duration = c_simdb_Duration
	End Property
	
	Public Property Get Countries()
		Countries = c_simdb_Countries
	End Property

	Public Property Get Country()
		Country = c_simdb_Country
	End Property
	
	Public Property Get MPAA()
		MPAA = c_simdb_MPAA
	End Property
	
	Public Property Get Budget()
		Budget = c_simdb_Budget
	End Property
	
	Public Property Get Top250()
		Top250 = c_simdb_Top250
	End Property
	
	Public Property Get EpisodeTitle()
		EpisodeTitle = c_simdb_EpisodeTitle
	End Property
	
	Public Property Get EpisodeAirDate()
		EpisodeAirDate = c_simdb_EpisodeAirDate
	End Property
	
	Public Property Get EpisodeLink()
		EpisodeLink = c_simdb_EpisodeLink
	End Property
	
	Public Property Get EpisodeID()
		EpisodeID = c_simdb_EpisodeID
	End Property
	
	Public Property Get EpisodeDescription()
		EpisodeDescription = c_simdb_EpisodeDescription
	End Property
	'#---------------------------------------------------------------------------#
	Public Function GetIMDBTag(sTagName)
		'********************************************************************************
		' Puropose : Get the value of a tag 
		' Input    : string : the tagID
		' Output   : string : the Then Value
		'********************************************************************************
		currentSub = "Class IMDB:GetIMDBTag"
	
		Dim ret
		GetIMDBTag = Eval("IMDB." & sTagName)
	
	End Function
	
	
	
	Private Function GetIMDBData(imdbID)
		'********************************************************************************
		' Puropose : Get the data from IMDB 
		' Input    : string : the imdbID
		' Output   : string : the Data
		'********************************************************************************
		'Dim currentSub : currentSub = "Class IMDB:GetIMDBData"
		currentSub = "Class IMDB:GetIMDBData"
		
		c_simdb_Link = "http://www.imdb.com/title/tt" & imdbID
		UserLog.LogEvent SUCCESS, "[" & currentSub & "]Getting data: " & c_simdb_Link

		IMDBData = Http.GetURL(c_simdb_Link)
		
		If Http.Status = 200 then
		
			UserLog.LogEvent SUCCESS, "[" & currentSub & "]Good Imdb Data received. Imdb Tag Extraction Started" 
			'Strip CrLf/Lf
			IMDBData =Replace(IMDBData,vbCrLf ,vbNullString)
			IMDBData =Replace(IMDBData,vbLf ,vbNullString)
			'Clean the data 
			regEx.Pattern 	= "( *>\s*< *)"
			IMDBData 		= regEx.Replace (IMDBData,"><")
			regEx.Pattern 	= "( +)"
			IMDBData 		= regEx.Replace (IMDBData," ")

			'For debug
			If IMDB.SaveDebugFile = True Then 
				Helper.SavetoFile IMDBData, SCRIPTPATH & "\" & IMDB.ID & ".html", 2, True
			End If
			
			'Extract the data
			GetType
			GetTitle
			GetTitleOriginal
			GetDescription
			GetStoryLine
			GetGenres
			GetReleaseDate
			GetSeasons
			GetRating
			GetVotes
			GetTagLine
			GetLinks
			GetOfficialLinks
			GetDirectors
			GetStars
			GetDuration
			GetCountry
			GetMPAA
			GetBudget
			GetScreens
			GetTop250
			
			UserLog.LogEvent SUCCESS, "[" & currentSub & "]Imdb Tag Extraction Complet"
			c_bMediaLoaded		= True
			
			If IMDB.MediaType = "TV" And IMDB.Season <> vbNullString And IMDB.Episode <> vbNullString Then
				IMDBTVData = Http.GetURL(c_simdb_Link & "/episodes")
				
				If Http.Status = 200 then
		
					UserLog.LogEvent SUCCESS, "[" & currentSub & "]Good TV Data received. TV Tag Extraction Started" 
					'Strip CrLf/Lf
					IMDBTVData =Replace(IMDBTVData,vbCrLf ,vbNullString)
					IMDBTVData =Replace(IMDBTVData,vbLf ,vbNullString)
					'Clean the data 
					regEx.Pattern 	= "( *>\s*< *)"
					IMDBTVData 		= regEx.Replace (IMDBTVData,"><")
					regEx.Pattern 	= "( +)"
					IMDBTVData 		= regEx.Replace (IMDBTVData," ")
			
					'For debug
					If IMDB.SaveDebugFile = True Then 
						Helper.SavetoFile IMDBTVData, SCRIPTPATH & "\" & IMDB.ID & "-Episodes.html", 2, True
					End if
	
					GetEpisodeTitle
					GetEpisodeAirDate
					GetEpisodeDescription
					GetEpisodeLink
					
					UserLog.LogEvent SUCCESS, "[" & currentSub & "]TV Tag Extraction Complet"
					c_bEpisodeLoaded		= True
				Else
					UserLog.LogEvent ERRORL, "[" & currentSub & "] Error getting TV page: " & c_simdb_Link & "/episodes" & ". The error was: " & Http.StatusText
				End If
			End If 					
		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Error getting page: " & c_simdb_Link & ". The error was: " & Http.StatusText
			c_bMediaLoaded		= false
		End If
	End Function 
	
	Private Function GetType()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Type"
		searchPattern 	= "<title>(.+?)</title>"
		'Return the result
		tmp_Type = LCase(Helper.MatchRegEx (IMDBData,searchPattern,1,True))
		
		If InStr(tmp_Type, "(video") Then
			c_simdb_Type = "Movie"
		ElseIf InStr(tmp_Type, "(tv series") Or InStr(tmp_Type, "(tv mini-series") Then
			c_simdb_Type = "TV"
		ElseIf InStr(tmp_Type, "(tv episode") Then
			c_simdb_Type = "TVEP"
		End if
	End Function 
	
	Private Function GetDescription()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Description"
		searchPattern 	= "<p itemprop=" & Chr(34) & "description" & Chr(34) &">(.+?)(</p>|<a href=)"
		'Return the result
		c_simdb_Description = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function 	

	Private Function GetTitle ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Title"
		searchPattern 	= "<h1 class=" & chr(34) & "header" & chr(34) & " itemprop=" & chr(34) & "name" & chr(34) & ">(.+?)<span"
		'Return the result
		c_simdb_Title = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetTitleOriginal ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Title (Original)"
		searchPattern 	= "<span class=" & chr(34) & "title-extra" & chr(34) & ">(.+?)<i>\(original title\)</i></span>"
		'Return the result
		c_simdb_TitleOriginal = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetStoryLine ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media StoryLine"
		searchPattern 	= "<h2>Storyline</h2><p>(.+?)(</p>|<em class=" & Chr(34) & "nobr" & Chr(34) & ">)"
		'Return the result
		c_simdb_StoryLine = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetGenres ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Genres"
		searchPattern 	= "<a href=" & Chr(34) & "/genre/.+?" & Chr(34) & " itemprop=" & Chr(34) & "genre" & Chr(34) & " ?>(.+?)</a>"
		'Return the result
		c_simdb_genres 	= Join(Helper.MatchRegEx (IMDBData,searchPattern,1,False),", ")
		c_simdb_genre 	= Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetReleaseDate()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media ReleaseDate"
		Select Case c_simdb_Type
			Case "Movie"
				searchPattern 	= "<time itemprop=" & Chr(34) & "datePublished" & Chr(34) & " datetime=" & Chr(34) & "(\d{4})-\d{2}-\d{2}" & Chr(34) & " ?>(.+?)</time>"
				'Return the result
		   		c_simdb_ReleaseDate 	= Helper.MatchRegEx (IMDBData,searchPattern,2,True)
		   		c_simdb_ReleaseYear 	= Helper.MatchRegEx (IMDBData,searchPattern,1,True)
		   	Case "TV"
		   		searchPattern 	= "<title>.+?\((tv mini-series|tv series)(.+?)\)(.?|.+?)</title>"
		   		'Return the result
		   		c_simdb_ReleaseDate 	= Helper.HTMLDecode(Helper.MatchRegEx (IMDBData,searchPattern,2,True))
		   		c_simdb_ReleaseYear 	= Helper.HTMLDecode(Helper.MatchRegEx (IMDBData,searchPattern,2,True))
		   	
		   	Case "TVEP"
				searchPattern 	= "<h4 class=" & Chr(34) & "inline" & Chr(34) & ">Original Air Date:</h4>(\d{1,2} [a-zA-Z]+ (\d{4}))</div>"
				'Return the result
		   		c_simdb_ReleaseDate 	= Helper.MatchRegEx (IMDBData,searchPattern,1,True)
		   		c_simdb_ReleaseYear 	= Helper.MatchRegEx (IMDBData,searchPattern,2,True)
		End select
	End Function
	
	Private Function GetSeasons()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Seasons"
	   		If IMDB.Season <> vbnullstring Then
	   			searchPattern 	= "<a href=" & Chr(34) & "episodes#season-" & IMDB.Season & Chr(34) & ">(\d{1,2})</a>"
	   		Else
	   			searchPattern 	= "<a href=" & Chr(34) & "episodes#season-\d{1,2}" & Chr(34) & ">(\d{1,2})</a>"
			End if
		'Return the result
   		c_simdb_Seasons 	= Join(Helper.MatchRegEx (IMDBData,searchPattern,1,False), ", ")
	End Function
	
	Private Function GetDuration()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Duration"
		searchPattern 	= "<time itemprop=" & Chr(34) & "duration" & Chr(34) & " datetime=.+>(.+)</time>"
		'Return the result
	   	c_simdb_Duration 	= Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	   	
	   	'Try title bar search If Not found
		If  c_simdb_Duration= vbNullString Then
			searchPattern 	=  "<div class=" & Chr(34) & "infobar" & Chr(34) & "><img width=.+?>(.+?)-&nbsp;&nbsp;<a"
			'Return the result
			c_simdb_Duration = Helper.HTMLDecode(Helper.MatchRegEx (IMDBData,searchPattern,1,True))
		End If
	End Function
	
	Private Function GetCountry ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Country"
		searchPattern 	= "<a href=" & Chr(34) & "/country/.+?" & Chr(34) & " ?>(.+?)</a>"
		'Return the result
		c_simdb_Countries 	= Join(Helper.MatchRegEx (IMDBData,searchPattern,1,False),", ")
		c_simdb_Country 	= Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetMPAA ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media MPAA Rating"
		searchPattern 	= "<span itemprop=" & Chr(34) & "contentRating" & Chr(34) & ">Rated (.+?) .+?</span>"
		'Return the result
		c_simdb_MPAA = Join(Helper.MatchRegEx (IMDBData,searchPattern,1,False), ", ")
		
		'Try title bar search If Not found
		If  c_simdb_MPAA= vbNullString Then
			searchPattern 	=  "<div class=" & Chr(34) & "infobar" & Chr(34) & "><img width=.+?alt=" & Chr(34) & "(.+?)" & Chr(34) & " src="
			'Return the result
			c_simdb_MPAA = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
		End if
	End Function

	Private Function GetRating ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media User Rating"
		searchPattern 	= "<span itemprop=" & Chr(34) & "ratingValue" & Chr(34) & ">(.+?)</span>"
	  	'Return the result
	   	c_simdb_Rating = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetTop250 ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Top250"
		searchPattern 	= "<a href=" & Chr(34) & "http://www.imdb.com/chart/top.+?" & Chr(34) & ">.+?Top 250 #([0-9]{1,3}).+?</a>"
	  	'Return the result
	   	c_simdb_Top250 = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetVotes ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Votes"
		searchPattern 	= "<span itemprop=" & Chr(34) & "ratingCount" & Chr(34) & ">(.+?)</span>"
	  	'Return the result
	   	c_simdb_Votes = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetTagLine ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media TagLine"
		searchPattern 	= "<h4 class=" & Chr(34) & "inline" & Chr(34) & ">Taglines:</h4>(.+?)<"
	  	'Return the result
	  	c_simdb_TagLine = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetOfficialLinks ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Official Links"
		searchPattern 	= "<h4 class=" & Chr(34) & "inline" & Chr(34) & ">Official Sites:</h4>(<a href=" & Chr(34) & "(.+?)" & Chr(34) & ".+?</a>.+?</span>)+"
	  	tmpStr = Helper.MatchRegEx (IMDBData,searchPattern,-1,True)
	  	'Return the result
	  	searchPattern 	= "<a href=" & Chr(34) & "(.+?)" & Chr(34) & ".+?</a>.+?</span>+"
		c_simdb_OfficialLinks = Join(Helper.MatchRegEx (tmpStr,searchPattern,1,False),", ")
		c_simdb_OfficialLink  = Helper.MatchRegEx (tmpStr,searchPattern,1,True)
	End Function
	
	Private Function GetLinks ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Links"
		searchPattern 	= "<td.+?id=" & Chr(34) & "img_primary" & Chr(34) & "><a.+?href=" & Chr(34) & "(/media/rm\d+/tt\d+)" & Chr(34) & "><img src=" & Chr(34) & "((.+?)(._SY\d{3,5}.+?).jpg)" & Chr(34) & " style=.+?></td>"
		'Return the result
		tmpStr = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
		If tmpStr <> vbNullString Then
		  	c_simdb_MediaLink 		= "http://www.imdb.com" & Helper.MatchRegEx (IMDBData,searchPattern,1,True)
		  	c_simdb_PosterThumbLink = Helper.MatchRegEx (IMDBData,searchPattern,2,True)
		  	c_simdb_PosterLink 		= Helper.MatchRegEx (IMDBData,searchPattern,3,True) & ".jpg"
	  	End If
	End Function
	
	Private Function GetDirectors ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Directors/Creators"
		If c_simdb_Type = "Movie" Or c_simdb_Type = "TVEP" Then
			searchPattern 	= "<a href=" & Chr(34) & "/name/nm\d{7}/" & Chr(34) & " itemprop=" & Chr(34) & "director" & Chr(34) & ">(.+?)</a>"
		Else 
			searchPattern 	= "<h4 class=" & Chr(34) & "inline" & Chr(34) & "> ?Creators?: ?</h4>+?<a href=" & Chr(34) & "/name/nm\d{7}/" & Chr(34) & ">(.+?)</a>"
		End If 
		'Return the result
		c_simdb_Directors = Join(Helper.MatchRegEx (IMDBData,searchPattern,1,False),", ")
		c_simdb_Director  = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetStars ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Stars"
		searchPattern 	= "href=" & Chr(34) & "/name/nm\d{7}/" & Chr(34) & " itemprop=" & Chr(34) & "actors" & Chr(34) & " ?>(.+?)</a>"
		'Return the result
		c_simdb_Stars  = Join(Helper.MatchRegEx (IMDBData,searchPattern,1,False),", ")
		c_simdb_Star   = Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetBudget ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Budget"
		searchPattern 	= "<h4 class=" & Chr(34) & "inline" & Chr(34) & ">Budget:</h4> ?(.+?)(\(.+?\))?</div>"
		'Return the result
		c_simdb_Budget =Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetScreens ()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Media Screens"
		searchPattern 	= "<h4 class=" & Chr(34) & "inline" & Chr(34) & ">Opening Weekend:</h4>.+?(\d{1,5}) Screens\)</div>"
		'Return the result
		c_simdb_Screens =Helper.MatchRegEx (IMDBData,searchPattern,1,True)
	End Function
	
	Private Function GetEpisodeTitle()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Episode_Title"
		searchPattern 	= "<h3>Season " & IMDB.Season & ", Episode " & IMDB.Episode & ": <a href=" & Chr(34) & "/title/tt\d{7}/" & Chr(34) & ">(.+?)</a></h3>"
		'Return the result
		c_simdb_EpisodeTitle = Helper.MatchRegEx (IMDBTVData,searchPattern,1,True)
	End Function 	
	
	Private Function GetEpisodeAirDate()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Episode Air Date"
		searchPattern 	= "<h3>Season " & IMDB.Season & ", Episode " & IMDB.Episode & ":.+?Original Air Date.+?<strong>(.+?)</strong></span>"
		'Return the result
		c_simdb_EpisodeAirDate = Helper.MatchRegEx (IMDBTVData,searchPattern,1,True)
	End Function 
	
	Private Function GetEpisodeDescription()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Episode Description"
		searchPattern 	= "<h3>Season " & IMDB.Season & ", Episode " & IMDB.Episode & ":.+?</span><br>(.+?)<"
		'Return the result
		c_simdb_EpisodeDescription = Helper.MatchRegEx (IMDBTVData,searchPattern,1,True)
	End Function 
	
	Private Function GetEpisodeLink()
		UserLog.LogEvent Information, "[" & currentSub & "] - Extracting Episode Link"
		searchPattern 	= "<h3>Season " & IMDB.Season & ", Episode " & IMDB.Episode & ": <a href=" & Chr(34) & "/title/tt(\d{7})/" & Chr(34) & ">.+?</a></h3>"
		'Return the result
		tmpStr = vbNullString 
		tmpStr = Helper.MatchRegEx (IMDBTVData,searchPattern,1,True)
		If tmpStr <> vbNullString Then
			c_simdb_EpisodeID   = tmpStr
			c_simdb_EpisodeLink = "http://www.imdb.com/title/tt" & tmpStr
		End If 
	End Function 		
	
	Public Function GetPoster (sFilePath)
		Dim currentSub : currentSub = "Class IMDB:GetPoster"
		
		If DEF_POSTER_SIZE <> 0 Then
			tmpStr = Replace(c_simdb_PosterLink,".jpg","._SY" & DEF_POSTER_SIZE & ".jpg")
		Else
			tmpStr = c_simdb_PosterLink
		End If
		GetPoster = http.GetURLtoFile (tmpstr,sFilePath & "\" & IMDB_POSTER_NAME & ".jpg", true )
		
		If GetPoster = True Then
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Successfully downloaded Poster " & sFilePath & "\" & IMDB_POSTER_NAME & ".jpg"
		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to download Poster"
		End if
	End Function
End Class

'######################################################################################
' Class Wrapper for Logging
'######################################################################################
Class UserLogClass
	
	Private bLoaded, bLogActive
	Private	sLogRoot,sLogFilePre,sLog
	Private oShell,oFso,oRegEx,oLog,oFldr,oFile
	Private iLogToKeep,iArr,iCnt,n,m,temp
	Private	aLog,aDate()
	Private cFiles
	
	Private Sub Class_Initialize
		iLogToKeep	= NUMBEROFLOGS
		bLoaded		= False
		bLogActive	= False
		sLogRoot 	= SCRIPTPATH & "\Log"
		sLogFilePre = SCRIPTNAME & "-" 
		Set oShell 	= WScript.CreateObject("Wscript.Shell")
		Set oFso	= CreateObject("Scripting.FileSystemObject")
	End Sub
	
	Private Sub Class_Terminate
		Dim currentSub : currentSub = "Class UserLog:Class_Terminate"
		
		'Clean up the logs
		DelLog
		
		Set oFso	= Nothing
		Set oShell	= Nothing
	End Sub
	
	Public Property Get LogPath()
		LogPath = sLogRoot
	End Property
	Public Property Let LogPath(sPath)
		If sPath <> vbNullString Then
			sLogRoot = sPath
		End If 
	End Property
	
	Public Property Get LogActive()
		LogActive = bLogActive
	End Property
	
	Public Property Get LogsToKeep()
		LogsToKeep = iLogToKeep
	End Property
	
	Public Property Let LogsToKeep(iValue)
		If (VarType(iValue) = vbInteger) Then
			iLogToKeep = iValue
		End If 
	End Property
	
	Public Property Get LogFile()
		LogFile = sLog
	End Property
	
	Public Function Start()
		'**********************************************************************************
		' Purpose : Initialize the Log interface, check log path
		'           Easily extend logging into other formats, Ex : Syslog, mail, xml etc.
		' Input   : none
		' Return  : bool	: True|False
		'**********************************************************************************
		Dim currentSub : currentSub = "Class UserLog:Initialize"
		
		If (Helper.FolderCreateRec(sLogRoot) = False) Then
			LogEvent ERRORL, ABORT
			WScript.quit
		End If
		
		sLog = sLogRoot & "\" & sLogFilePre & Helper.GetDayTimeDate() & ".log"
		If (oFso.FileExists(sLog)) Then
			LogEvent INFORMATION, "[" & currentSub & "] The logfile: " & sLog & " allready exists. Appending random number to name of logfile"
			sLog = sLogRoot & sLogFilePre & Helper.GetDayTimeDate() & "_" & Helper.Random(9999) & ".log"
		End If
		
		LogEvent INFORMATION, "[" & currentSub & "] Logfile = " & sLog
		
		bLogActive = True
	End Function
	
	Public Sub LogEvent(eventType, sMessage)
		'**********************************************************************************
		' Purpose : Log interface, write various type of events to different formats, 
		'			NT Event, File etc.
		'           Easily extend logging into other formats, Ex : Syslog, mail, xml etc.
		' Input   : i : Event type, Integer 0 = None 1 = Success/Error 2 = Full
		'           sMessage : Log message, String
		'**********************************************************************************
		'Eventlog output
		If EVENTLOG = 1 Or EVENTLOG = 2 Then
			Set oRegEx = New RegExp
			'oRegEx.Pattern = "\[.*\] "
			'Changed to be able to print message file output when Message contains Brackets]
			oRegEx.Pattern = "^(\[[^*\]]*\])+"
			sMessage = oRegEx.Replace (sMessage, "")
			doEventLog eventType, Trim(sMessage)
			Set oRegEx = Nothing
		End If
		
		'Debug EventLog output
		If EVENTLOG = 3 Then
			doEventLog eventType, sMessage
		End If
		
		'Logfile output
		If FILELOG = 1 Or FILELOG = 2 Then
			Set oRegEx = New RegExp
			'oRegEx.Pattern = "\[.*\] "
			'Changed to be able to print message file output when Message contains Brackets]
			oRegEx.Pattern = "^(\[[^*\]]*\])+"
			sMessage = oRegEx.Replace (sMessage, "")
			doFileLog eventType, Trim(sMessage)
			Set oRegEx = Nothing
		End If
		
		'Debug logfile output
		If FILELOG = 3 Then
			doFileLog eventType, sMessage
		End If	
		
		'Debug screen output
		If FILELOG = 3 Or EVENTLOG = 3 Then
			WScript.echo sMessage
		End If
	End Sub
	
	Private Sub doFileLog(eventType, sMessage)
		'**********************************************************************************
		' Purpose : Write Event to logfile. Build an array of events until path logfile 
		'			is determined.
		'           If logfile can not be written. Events are redirected to eventlog.
		'           EventLog Level 0 = None 1 = Success/Error 2 = Full
		' Input   : eventType : Event type, Integer
		'           0 SUCCESS	1 ERROR (Const ERRORL)	2 WARNING	4 INFORMATION
		'           s : Log message, String
		' Use     : bLog Boolean True|False when actually start logging to file
		'**********************************************************************************
		On Error Resume Next
		
		Dim currentSub : currentSub = "Class UserLog:FileLog"
		
		'WScript.Echo eventType & " : " & sMessage
		'Make sure errorlevel 0
		Err.clear
		
		'Log to file if bLog flag is true
		If bLogActive = True Then
			
			Set oLog = oFso.OpenTextFile(sLog, FORAPPENDING, True)
			
			If Err.number <> 0 Then
				Helper.EchoErr Err, currentSub
				'Clear error
				Err.clear
				'Check if log folder exists, try to create
				If Helper.FolderCreateRec(Left(sLog, InStrRev(sLog, "\"))) <> -1 Then
					Set oLog = oFso.OpenTextFile(sLog, FORAPPENDING, True)
					
				Else
					
					'Abort filelog operation if can't be written, switch to EventLog	
					EVENTLOG = 2
					FILELOG = 0
					Err.Raise = iErr
					LogEvent ERRORL, "[" & currentSub & "] Error occured while writing to logfile: " & sLog & ". The error was: " & Err.description
					LogEvent WARNING, "[" & currentSub & "] Events will permanently be redirected to eventlog. All events occured prior to this warning will now be written."
					
					'Write events from array to eventlog
					If IsArray(aLog) And aLog(0) <> vbNullString Then
						For iArr = 0 To UBound(aLog)
							LogEvent CInt(Left(aLog(iArr), 1)), Right(aLog(iArr), Len(aLog(iArr)) - 1)
						Next
						
						ReDim aLog(0)	
					End If
					
					Exit Sub
				End If
			End If
			
			'Write events from array to logfile
			If IsArray(aLog) And aLog(0) <> vbNullString Then
				For iArr = 0 To UBound(aLog)
					oLog.WriteLine Right(aLog(iArr), Len(aLog(iArr)) - 1)
				Next
				
				ReDim aLog(0)
			End If
			
			Select Case FILELOG
				Case 1
				Select Case eventType
					Case SUCCESS
					oLog.WriteLine Now & " SUCCESS " & sMessage
					Case ERRORL
					oLog.WriteLine Now & " ERROR   " & sMessage
					Case Else
					'Exit Sub 
				End Select
				Case 2
				Select Case eventType
					Case SUCCESS
					oLog.WriteLine Now & " SUCCESS     " & sMessage
					Case ERRORL
					oLog.WriteLine Now & " ERROR       " & sMessage
					Case WARNING
					oLog.WriteLine Now & " WARNING     " & sMessage
					Case INFORMATION
					oLog.WriteLine Now & " INFORMATION " & sMessage
					Case Else
					'Exit Sub
				End Select
				Case 3
				Select Case eventType
					Case SUCCESS
					oLog.WriteLine Now & " SUCCESS     " & sMessage
					Case ERRORL
					oLog.WriteLine Now & " ERROR       " & sMessage
					Case WARNING
					oLog.WriteLine Now & " WARNING     " & sMessage
					Case INFORMATION
					oLog.WriteLine Now & " INFORMATION " & sMessage
					Case Else
					'Exit Sub
				End Select
				Case Else
				Exit Sub
			End Select
			
			oLog.close
			'Set oLog = Nothing
		Else
			
			'Log to array while path to logfile determined
			If IsArray(aLog) Then
				iArr = UBound(aLog) + 1
				ReDim Preserve aLog(iArr)
			Else
				ReDim aLog(0)
				iArr = UBound(aLog)
			End If
			
			Select Case FILELOG
				Case 1
				Select Case eventType
					Case SUCCESS
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " SUCCESS " & sMessage
					Case ERRORL
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " ERROR   " & sMessage
					Case Else
					ReDim Preserve aLog(iArr-1)
					Exit Sub
				End Select
				Case 2
				Select Case eventType
					Case SUCCESS
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " SUCCESS     " & sMessage
					Case ERRORL
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " ERROR       " & sMessage
					Case WARNING
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " WARNING     " & sMessage
					Case INFORMATION
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " INFORMATION " & sMessage
					Case Else
					Exit Sub
				End Select
				Case 3
				Select Case eventType
					Case SUCCESS
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " SUCCESS     " & sMessage
					Case ERRORL
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " ERROR       " & sMessage
					Case WARNING
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " WARNING     " & sMessage
					Case INFORMATION
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " INFORMATION " & sMessage
					Case Else
					Exit Sub
				End Select
				Case Else
				Exit Sub
			End Select
		End If
	End Sub
	
	Private Sub doEventLog(eventType, sMessage)
		'********************************************************************************
		' Purpose : Write Event to Eventlog.
		'           EventLog Level 0 = None 1 = Success/Error 2 = Full
		' Input   : eventType : Event type, Integer
		'           0 SUCCESS 1 ERROR (Const ERRORL) 2 WARNING 4 INFORMATION
		'           sMessage : Log message, String
		'********************************************************************************
		Select Case EVENTLOG
			Case 1
			Select Case eventType
				Case SUCCESS
				oShell.LogEvent eventType, sMessage
				Case ERRORL
				oShell.LogEvent eventType, sMessage
				Case Else
				Exit Sub
			End Select
			Case 2
			Select Case eventType
				Case SUCCESS
				oShell.LogEvent eventType, sMessage
				Case ERRORL
				oShell.LogEvent eventType, sMessage
				Case WARNING
				oShell.LogEvent eventType, sMessage
				Case INFORMATION
				oShell.LogEvent eventType, sMessage
				Case Else
				Exit Sub
			End Select
			Case 3
			Select Case eventType
				Case SUCCESS
				oShell.LogEvent eventType, sMessage
				Case ERRORL
				oShell.LogEvent eventType, sMessage
				Case WARNING
				oShell.LogEvent eventType, sMessage
				Case INFORMATION
				oShell.LogEvent eventType, sMessage
				Case Else
				Exit Sub
			End Select
			Case Else
			Exit Sub
		End Select
	End Sub
	
	Public Sub DelLog()
		'**********************************************************************************
		' Purpose : Delete obsolete logs
		' Input   : None
		'**********************************************************************************
		Dim currentSub : currentSub = "Class UserLog:DelLog"
		
		UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] Log CleanUP Started"
		
		If iLogToKeep <> 0 Then
			LogEvent INFORMATION, "[" & currentSub & "] Call KeepOnlyFiles " & sLogRoot & " " & iLogToKeep
			KeepOnlyFiles sLogRoot, iLogToKeep
		End If
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] Log CleanUP Complete"
		UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] " & APPNAME & " " & APPVERMAJOR &  "." & APPVERMINOR & " Completed in " & Helper.ExecTime(tStartTime, Now)
	End Sub
	
	Private Sub KeepOnlyFiles(sPath, iCount)
		'**********************************************************************************
		' Purpose : Delete obsolete files based upon date.
		'           n newest files are kept.
		' Input   : String (s) Path to root of files
		'           Integer : iCount : Number of folders to keep
		'**********************************************************************************
		'On Error Resume Next
		On Error Goto 0
		Err.Clear
		
		Dim cFiles
		Dim currentSub : currentSub = "Class UserLog:KeepOnlyFiles"
			
		Set oFldr = oFso.GetFolder(sPath)
		Helper.EchoErr Err, currentSub
		
		If Err.number <> 0 Then
			LogEvent ERRORL, "[" & currentSub & "] An Error occured connecting to: " & sPath & " old files must be deleted manually."
			Exit Sub
		Else
			LogEvent INFORMATION, "[" & currentSub & "] Connected to: " & sPath
		End If
		
		Set cFiles = oFldr.Files
		Helper.EchoErr Err, currentSub
		
		If Err.number <> 0 Then
			LogEvent ERRORL, "[" & currentSub & "] An Error occured while listing files in folder: " & sPath & ". Old files must be deleted manually."
			Exit Sub
		Else
			LogEvent INFORMATION, "[" & currentSub & "] Succsessfully listed files in folder: " & sPath
		End If
		
		iCnt = 0
		'build the date array
		For Each ofile In cFiles
			If InStr(oFile.Name, sLogFilePre) > 0 then
				ReDim Preserve aDate(iCnt)
				LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & oFile.DateCreated & " (Path: " & oFile.Path & ")"
				aDate(iCnt) = oFile.DateCreated
				iCnt = iCnt + 1
			end If 
		Next 
		LogEvent INFORMATION, "[" & currentSub & "] Creating array with fixed size: " & iCnt & ". Adding date of folders to array"
		
		On Error Resume Next
		Err.Clear
		'Check if number of files greater than i
		If (UBound(aDate)+1) <= iCount Then
			If Err.Number <> 0 Then
				LogEvent INFORMATION, "[" & currentSub & "] Number of file(s) in root is: 0. Number is less or equal to: " & iCount & " which is the number of file(s) to keep."
				Err.Clear
			Else
				LogEvent INFORMATION, "[" & currentSub & "] Number of file(s) in root is: " & UBound(aDate)+1 & ". Number is less or equal to: " & iCount & " which is the number of file(s) to keep."
			End If
			Exit Sub
		End If
		
		LogEvent INFORMATION, "[" & currentSub & "] Number of files in root is: " & UBound(aDate) +1 & ". Number is greater: " & iCount & " wihch is the number of file(s) to keep."
		
		'Sorting array by date, ascent sort order (The famous bubble sort)
		LogEvent INFORMATION, "[" & currentSub & "] Sorting dates in array, ascent sort order"
		For n = 0 To UBound(aDate) -1 
			For m = n+1 To UBound(aDate) 
				If aDate(m) < aDate(n) Then
					temp = aDate(m)
					aDate(m) = aDate(n)
					aDate(n) = temp
				End If
			Next
		Next
		
		'Just logging
		LogEvent INFORMATION, "[" & currentSub & "] Array sorted, result in ascent order: "
		For iCnt = 0 To UBound(aDate)
			LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt)
		Next
		
		'Cut array, keep (i) rows with date of folders wich is going to be deleted
		ReDim Preserve aDate(UBound(aDate) - iCount)
		LogEvent INFORMATION, "[" & currentSub & "] Array aDate cut, remaing rows are: "
		
		'Even more logging (those debuggers ;))
		For iCnt = 0 To UBound(aDate)
			LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt)
		Next
		
		LogEvent INFORMATION, "[" & currentSub & "] Start deleting file(s)..."
		For Each oFile In cFiles
			For iCnt = 0 To UBound(aDate)
				If oFile.DateCreated = aDate(iCnt) Then
					LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt) & " matches DateCreated on file: " & oFile.Path & " (Date=" & oFile.DateCreated & ")"
					Helper.FileDelete oFile.Path
					Exit For
				End If
			Next
		Next
		
		Helper.EchoErr Err, currentSub
		
		If Err.Number = 0 Then
			LogEvent SUCCESS, "[" & currentSub & "] Deleted " & UBound(aDate)+1 & " obsolete log files" 
		End If
		
	End Sub
End Class
'######################################################################################
' Class Wrapper for Helper. Functions
'######################################################################################
Class HelperClass
	
	Public oShell,oExec,oFso,oFile,oFolder,oStdOut,Element,cmdOutput,oStream
	Private iSize,iInt,iCnt,iWordBreak,iCurrentLenth
	Public sScriptDir, sFilePath, sStreamData, sFolder, sUnc, sResult, sTempFile
	Private aResult
	Private bFound
	Public objRegExp, strPattern
	'GetDayTimeDate
	Public intSeconds, intMilliseconds
	'KeepOnly
	Private cCollection, oObject, sType, aDate, oFldr, n, m, temp, iCnt2, aDeleted()
	'GetFolderContent
	Public folder, items, item, FolderExists2, sType2, arrList(),i , sName
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		Set oFso		= CreateObject("Scripting.FileSystemObject")
		Set oShell		= CreateObject("Wscript.Shell")
		Set oStream		= CreateObject("adodb.stream")
	End Sub
	
	Private Sub Class_Terminate
		Set oFso		= Nothing
		Set oShell		= Nothing
	End Sub
	'#---------------------------------------------------------------------------#
	
		
	Function EchoErr(myError, sProcedure)
		'**********************************************************************************
		' Purpose : Verify and Post Err message
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:EchoErr"
		
		If Err.Number <> 0 Then
			'WScript.echo "["& sProcedure & "] ERROR: Number:" & Err.Number & " : " & Err.Description
			UserLog.LogEvent ERRORL, "["& sProcedure & "] ERROR: Number:" &Err.Number & " : " & Err.Description
		End If
	End Function
	
	Sub import (sFileName)
		'**********************************************************************************
		' Purpose : Import an external script file 
		' Inputs  : Srting : sFileName : the file name
		' Output  : None
		'**********************************************************************************
		sScriptDir = oFso.GetParentFolderName(WScript.ScriptFullName)   
		sFilePath = oFso.BuildPath(sScriptDir,sFileName)   
		Const ForReading = 1   
		
		Set oFile = oFso.OpenTextFile(sFilePath,ForReading)   
		sStreamData = oFile.ReadAll()   
		ExecuteGlobal sStreamData   
	End Sub

	Public Function GetTempFilename()
		'**********************************************************************************
		' Purpose : Generate e temporary file, 
		' Inputs : None
		' Output : StringArray  : ShellRun : the actual output if any
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:GetTempFilename"
		
		GetTempFilename = oShell.ExpandEnvironmentStrings("%temp%") & oFso.GetTempName
	End Function
	
	Public Function FixDirectoryName(ByVal sStr)
		'**********************************************************************************
		' Purpose : Fix string to Ucase every 1st letter of each word
		' Input   : sStr  : the string to process
		' Return  :       : The prossesed string
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:FixDirectoryName"
		Dim aStr, sItem, iCnt, aList, sListItem, n , strAsc
		Dim objRegExp : Set objRegExp = CreateObject("VBScript.RegExp")
		
			'Remove Unallowed chars
			sStr = Replace(sStr,"/", "_")
			sStr = Replace(sStr,"\", "_")
			sStr = Replace(sStr,"*", "_")
			sStr = Replace(sStr,":", "_")
			sStr = Replace(sStr,"?", "_")
			sStr = Replace(sStr,"<", "_")
			sStr = Replace(sStr,">", "_")
			sStr = Replace(sStr,"|", "_")
		
			'remove any bad leading and tailing caracters
			With objRegExp 
			    .Pattern = "^[^a-zA-Z0-9]+|[^a-zA-Z0-9]+$"
			    .IgnoreCase = True 
				.Global = True 
			End With 
			sStr = objRegExp.replace(sStr,"") 
			
		If sStr = "" Then
			FixStr = ""
		Else
			FixStr = sStr
		End If
	End Function
	
		

	Public Function ShellRun(sCmd, iWinStyle, bWait, sWorkDir)
		'**********************************************************************************
		' Purpose : Execute a command, It will then execute the command in a shell, 
		'           and capture the output into a file. That file is then read in and its 
		'           contents are returned as an Array() in the value the function returns.
		' Inputs : String : sCmd : The command to execute
		'		   Integer: iWinStyle : the window style (check VBS help for values)
		'		   Bool   : bWait : Wait for execution complete and return the output
		' Output : Array  : ShellRun : the actual output if any
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:ShellRun"
				
		sTempFile = GetTempFilename()
		On Error Resume Next 
		
		Dim sCmdOnly, sCmdPath, sCmdDrive, sCmdWorkDir
		Dim COMSPEC : COMSPEC = "%comspec% /c "
		
		UserLog.LogEvent Information, "[" & currentSub & "] Command is : ["  & sCmd  & "]" & " and Work dir is: " & sWorkDir
		
		'Switch the current dir to sWorkDir or Default to command exe dir
		If sWorkDir <> vbNullString Then
			sCmdWorkDir = sWorkDir
		Else
			'Build the %comspec% to set drive and work directory
			If InStr(sCmd,Chr(34)) = 1 Then 'command is quoted
				sCmdOnly = Left(sCmd, InStr(2,sCmd,Chr(34)))
				sCmdOnly = Replace(sCmdOnly,Chr(34),vbNullString)
			Else
				sCmdOnly = Left(sCmd, InStr(2,sCmd,Chr(32)))
				sCmdOnly = Replace(sCmdOnly,Chr(32),vbNullString)
			End If 	
			sCmdWorkDir = Left(sCmdOnly, InStrRev(sCmdOnly,"\")-1)
		End If
		
		'Build the COMSPEC
		If InStr(sCmdWorkDir,":") = 2 Then 
			'extract drive info
			sCmdDrive = Left(sCmdWorkDir, InStr(sCmdWorkDir,":"))
			COMSPEC = COMSPEC & sCmdDrive & " " & chr(38) & " "
			'extract Path info
			sCmdpath = sCmdWorkDir
			If InStr(sCmdPath,Chr(32)) > 0 Then
				sCmdPath = Chr(34) & sCmdPath & Chr(34)
			End if
			COMSPEC = COMSPEC & "cd " & sCmdPath & " " & chr(38) & " "
		End If 
				
		If bWait Then
			oShell.Run COMSPEC &  sCmd  & " > " & sTempFile, iWinStyle, true
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Command Execute (Wait): [" & COMSPEC & sCmd  & " > " & sTempFile & "]"
			If Helper.FileExists(sTempFile,False) Then
				cmdOutput = Split(oFso.OpenTextFile(sTempFile,1).ReadAll,vbCRLF)
				If Err.Number = 62 Then
					UserLog.LogEvent WARNING, "[" & currentSub & "] No Output result from Command Execute"
					'Clear error
					Err.Clear
				Else
					'Just Debug
					UserLog.LogEvent SUCCESS, "[" & currentSub & "] Command has Output."
					For iCnt = 0 To UBound(cmdOutput)
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] -" & cmdOutput(iCnt)
					Next
				End If
	
				oFso.DeleteFile sTempFile, true
			Else
				UserLog.LogEvent WARNING, "[" & currentSub & "] No Output From Command Execute"
			End If  
			ShellRun = cmdOutput
		Else 
			oShell.Run COMSPEC & sCmd, iWinStyle, false
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Command Execute (No Wait): " & sCmd
			ShellRun = Array()
		End If 
			
		If Err.Number <> 0 Then
			Helper.EchoErr Err, currentSub
			'Clear error
			Err.clear
		End If
	End Function

	Function SavetoFile(sData, sFilePath, iStreamType, bOverwrite )
		'**********************************************************************************
		' Purpose : Save data to a file.
		' Inputs : String : sData : The data to be saved
		'		   String : sFilePath : The full file path to save to
		'		   Integer: iStreamType : adTypeBinary = 1 / adTypeText = 2
		'		   Bool   : bOverwrite : force overwrite of the destination file
		' Output : Bool   : success = true / error = false 
		'**********************************************************************************		
		Dim currentSub : currentSub = "Class Helper:SavetoFile"
		'On Error Resume Next
		
		'Force unicode if text data
		If iStreamType = 2 Then
			oStream.Charset = "ISO-8859-1"
		End if
		
		oStream.Type = iStreamType    
		oStream.mode=3    'read-write
		oStream.open
		oStream.WriteText sData
		
		If bOverwrite <> False Then
			oStream.savetofile sFilePath,2    'save-create-overwrite
		Else
			oStream.savetofile sFilePath,1    'save-create-notExist
		End If 
		ostream.Close
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "["& currentSub & "] ERROR: Number:" &Err.Number & " : " & Err.Description
			SavetoFile = False
			Exit Function
		Else
			UserLog.LogEvent SUCCESS, "["& currentSub & "] Successfully saved " & sFilePath
			SavetoFile = true
		End If
	End Function

	Public Function Validate(sStringToTest,aArray)
		'**********************************************************************************
		' Purpose : Check if the element is part of an array
		'**********************************************************************************
		bFound = False
		
		If (IsArray(aArray)) Then
			For Each Element In aArray				
				If LCase(sStringToTest) = LCase(Element) Then
					bFound = True
					Exit For
				End If
			Next 
		End If
		Validate = bFound
	End Function 
	
	Public Function FileMatchesPattern(strFileName, strWildCard) 
		'**********************************************************************************
		' Purpose : Function to test if a filename matches the wildcard characters passed. 
		' Converts a wildard (*.vbs) to a valid regular expression so that the file name 
		' can be tested for a match using a regular expression object.  
		' This negates the need to perform a lot of string parsing and comparison. 
		'         
		' Params:  strFileName   String, Holding the name of the file to test (must not include the path) 
		'          strWildCard   String, Holding the wildcard string used to compare the file with. (eg. "*.vbs") 
		' Returns: True          if the filename matches the wildcard, otherwise False. 
		'**********************************************************************************	  
        Set objRegExp = CreateObject("VBScript.RegExp") 
         
        ' Update the wildcard string to define a valid regular expression 
        strPattern = Replace(strWildCard, ".", "\.") 
        strPattern = Replace(strPattern, "*", ".*") 
        strPattern = "^" & strPattern & "$" 
         
        With objRegExp 
                .Pattern = strPattern 
                .IgnoreCase = True 
                .Global = True 
        End With 
         
        FileMatchesPattern = objRegExp.Test(strFileName) 
        'WScript.Echo "File: [" & strFileName & "] matches Pattern: [" & strPattern & "] = " &  FileMatchesPattern 
        Set objRegExp = Nothing 
	End Function 

	Public Function GetSize(varArray)
		'**********************************************************************************
		' Purpose : Check the array size
		'**********************************************************************************
		iSize = 0
		
		On Error Resume Next
		iSize = UBound(varArray)
		If Err.Number Then
			If Err.Number = 9 Then
				iSize = 0
			End If
		Else
			iSize = UBound(varArray) + 1
		End If
		GetSize = iSize
	End Function 
	
	Public Function IsNothing (Obj)
		'**********************************************************************************
		' Purpose : Check if object is Nothing
		'**********************************************************************************
		If TypeName(Obj) = "Nothing" Then
			IsNothing = True
		Else
			IsNothing = False
		End If
	End Function
	
	Public Function FileDeletePattern(strFilePath, strWildCard) 
		'**********************************************************************************
		' Purpose : Delete files matching a pattern
		' Params:  strFilePath   String, Holding the name of the folder to test 
		'          strWildCard   String, Holding the wildcard string used to compare the file name with. (eg. "*.vbs") 
		' Returns: FileName      if the filename matches the wildcard, otherwise vbnullstring
		'**********************************************************************************	  
        Dim currentSub : currentSub = "Class Helper:FileDeletePattern"
        Set objRegExp = CreateObject("VBScript.RegExp") 
        
        On Error Resume next 
        ' Update the wildcard string to define a valid regular expression 
        strPattern = Replace(strWildCard, "[", "\[")
        strPattern = Replace(strPattern, "]", "\]")
        strPattern = Replace(strPattern, "{", "\{")
        strPattern = Replace(strPattern, "}", "\}")
        strPattern = Replace(strPattern, "(", "\(")
        strPattern = Replace(strPattern, ")", "\)")
        strPattern = Replace(strPattern, "+", "\+")
        strPattern = Replace(strPattern, "?", "\?")
        strPattern = Replace(strPattern, ".", "\.") 
        strPattern = Replace(strPattern, "*", ".*") 
        strPattern = "^" & strPattern & "$" 
         
        With objRegExp 
                .Pattern = strPattern 
                .IgnoreCase = True 
                .Global = True 
        End With 
         
        'process the file collection
    	Set folder = oFso.GetFolder(strFilePath)
	    
	    If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "["& currentSub & "] ERROR: Number:" &Err.Number & " : " & Err.Description
			exit function
		End If
	     
	    For Each item in Folder.Files      
    	     If objRegExp.Test(item.Name) = True Then
    	     	Helper.FileDelete strFilePath & "\" & item.Name
    	        'UserLog.LogEvent INFORMATION, "[" & currentSub & "] file Matched: " & item.Name
    	    End If     
	    Next    

        Set objRegExp = Nothing 
	End Function 
	
	Public Function FolderDeletePattern(strFolderPath, strWildCard) 
		'**********************************************************************************
		' Purpose : Delete Folders matching a pattern
		' Params:  strFolderPath   String, Holding the name of the folder to test 
		'          strWildCard   String, Holding the wildcard string used to compare the file name with. (eg. "*.vbs") 
		'**********************************************************************************	  
        Dim currentSub : currentSub = "Class Helper:FolderDeletePattern"
        Set objRegExp = CreateObject("VBScript.RegExp") 
        
        On Error Resume next 
        ' Update the wildcard string to define a valid regular expression 
        strPattern = Replace(strWildCard, "[", "\[")
        strPattern = Replace(strPattern, "]", "\]")
        strPattern = Replace(strPattern, "{", "\{")
        strPattern = Replace(strPattern, "}", "\}")
        strPattern = Replace(strPattern, "(", "\(")
        strPattern = Replace(strPattern, ")", "\)")
        strPattern = Replace(strPattern, "+", "\+")
        strPattern = Replace(strPattern, "?", "\?")
        strPattern = Replace(strPattern, ".", "\.") 
        strPattern = Replace(strPattern, "*", ".*") 
        strPattern = "^" & strPattern & "$" 
         
        With objRegExp 
                .Pattern = strPattern 
                .IgnoreCase = True 
                .Global = True 
        End With 
         
        'process the file collection
    	Set folder = oFso.getfolder(strFolderPath)
	    
	    If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "["& currentSub & "] ERROR: Number:" &Err.Number & " : " & Err.Description
			exit function
		End If
	     
	    For Each item in Folder.SubFolders      
    	     If objRegExp.Test(item.Name) = True Then
    	        UserLog.LogEvent INFORMATION, "[" & currentSub & "] Folder Matched: " & item.Name
    	        Helper.FolderDelete strFolderPath & "\" & item.Name
    	    End If     
	    Next    

        Set objRegExp = Nothing 
	End Function 
	
	Public Function FileExistsPattern(strFilePath, strWildCard) 
		'**********************************************************************************
		' Purpose : Function to check if a filename matches the wildcard characters passed. 
		' Converts a wildard (*.vbs) to a valid regular expression so that the file name 
		' can be tested for a match using a regular expression object.  
		'         
		' Params:  strFilePath   String, Holding the name of the folder to test 
		'          strWildCard   String, Holding the wildcard string used to compare the file name with. (eg. "*.vbs") 
		' Returns: FileName      if the filename matches the wildcard, otherwise vbnullstring
		'**********************************************************************************	  
        Dim currentSub : currentSub = "Class Helper:FileExistsPattern"
        Set objRegExp = CreateObject("VBScript.RegExp") 
        
        On Error Resume next 
        ' Update the wildcard string to define a valid regular expression 
        strPattern = Replace(strWildCard, ".", "\.") 
        strPattern = Replace(strPattern, "*", ".*") 
        strPattern = "^" & strPattern & "$" 
         
        With objRegExp 
                .Pattern = strPattern 
                .IgnoreCase = True 
                .Global = True 
        End With 
         
        'process the file collection
    	Set folder = oFso.getfolder(strFilePath)
	    
	    If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "["& currentSub & "] ERROR: Number:" &Err.Number & " : " & Err.Description
			exit function
		End If
	     
	    
	    For Each item in Folder.Files      
    	     If objRegExp.Test(item.Name) = True Then
    	        FileExistsPattern =  item.Name   
	    	    Exit for      
    	    End If     
	    Next    

        Set objRegExp = Nothing 
	End Function 	
	
	Function FileExists(sFilePath, bRequired)
		'**********************************************************************************
		' Purpose : Verify presense of a file, abort the script if the file is not present
		'		    and it's required.
		' Input   : string	: sFilePath 		: Path to file
		'           bool	: bRequired	: True|False
		' Return  : bool	: True|False
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:FileExists"
		
		If (oFso.FileExists(sFilePath)) Then
			'UserLog.LogEvent INFORMATION, "[" & currentSub & "] The file: " & sFilePath & " is present."
			FileExists = True
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] The file: " & sFilePath & " does not exist."
			FileExists = False
		End If
		
		If bRequired And FileExists = False Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] The file: " & sFilePath & " is required for futher processing of this script."
		End If
	End Function
	
	Function FolderExists(sFolderPath, bRequired)
		'**********************************************************************************
		' Purpose : Verify presense of a folder, abort the script if the folder is not present
		'		    and it's required.
		' Input   : string	: sFFolderPath 		: Path to folder
		'           bool	: bRequired	: True|False
		' Return  : bool	: True|False
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:FolderExistsExists"
		
		If (oFso.FolderExists(sFolderPath)) Then
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] The Folder: " & sFolderPath & " is present."
			FolderExists = True
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] The Folder: " & sFolderPath & " does not exist."
			FolderExists = False
		End If
		
		If bRequired And FolderExists = False Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] The folder: " & sFolderPath & " is required for futher processing of this script."
			Helper.Terminate
		End If
	End Function
	
	Function GetFolderContent(sFolderPath, bType, sMask)
		'**********************************************************************************
		' Purpose : Gets the content of a folder, abort the script if the folder is not present
		'		    and it's required.
		' Input   : string	: sFolderPath : Path to folder
		'			bool	: bType : False:Files | True:Folder
		'           string  : sMask : the masque to check against
		' Return  : Array	: Array of file/folder Names
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:GetFolderContent"
		
		If (oFso.FolderExists(sFolderPath)) Then
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] The Folder: " & sFolderPath & " is present."
			
			Set folder = oFso.GetFolder(sFolderPath)
			
			Select Case bType
				Case True
					sType2 = "Folder"
					Set items = folder.SubFolders
				Case False
					sType2 = "File"
					Set items = folder.Files
			End Select
			
			If items.count > 0 then
				i=0
				For each item In items
					If Helper.FileMatchesPattern (item.Name, sMask) then
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] Found " & sType2 & ": " & item.Name
						ReDim Preserve arrList(i)
						arrList(i) = item.Name
						i = i + 1
					End if
				Next
			End If 
			GetFolderContent = arrList

		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] The Folder: " & sFolderPath & " does not exist."
			Set GetFolderContent = Array()
		End If
	End Function
	
	Function GetFolderDate(sFolderPath, iDateProperty)
		'**********************************************************************************
		' Purpose : Gets the Date property of a folder
		' Input   : string	: sFolderPath : Path to folder
		'	        string  : sDateProperty : 1:DateCreated|2:DateLastAccessed|3:DateLastModified
		' Return  : date	: the date
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:GetFolderDate"
		
		If (oFso.FolderExists(sFolderPath)) Then
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] The Folder: " & sFolderPath & " is present."
			
			Set folder = oFso.GetFolder(sFolderPath)
			
			Select Case iDateProperty
				Case 1
					GetFolderDate = folder.DateCreated
				Case 2
					GetFolderDate = folder.DateLastAccessed
				Case Else
					GetFolderDate = folder.DateLastModified
			End Select
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Folder date is : " & GetFolderDate
		End If
	End Function
			
	Function CleanString (str)
		'********************************************************************************
		' Purpose : clean any leading/trailing spaces and %20 caracters
		' Input   : string	: str		: the input string
		' Output  : string  : the cleaned string
		'********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:CleanString"
		
		'Trim with spaces
			str = Trim(str)
		'clear %20
			str = Replace(str,"%20"," ")
		CleanString = str
	End Function
	
	Function FileCreate(sPath)
		'**********************************************************************************
		' Purpose : Create a File
		' Input   : string	: sPath	: Path to File
		' Return  : integer	: False : File creation error
    	'					  True  : File successfully created
		'**********************************************************************************
		On Error Resume next
		sFolder = vbnullString
		
		Dim currentSub : currentSub = "Class Helper:FileCreate"
		
		'Get the starting point
		sFolder = Left(sPath, InStrRev(sPath, "\")-1)
		
		'Check and create the file
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Checking if folder exists: " & sFolder
		If oFso.FolderExists(sFolder) Then
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating file: " & sPath
			ofso.CreateTextFile(sPath)
			If Err.number <> 0 Then
				UserLog.LogEvent ERRORL, "[" & currentSub & "] Error creating: " & sPath & ". The error was: " & Err.description
				FileCreate = false
				Exit Function
			Else 
			    UserLog.LogEvent SUCCESS, "[" & currentSub & "] Created File: " & sPath
				FileCreate = true 
			End If
		Else 
			FileCreate = False
		End If
	End Function

	Function FolderCreate(sPath)
		'**********************************************************************************
		' Purpose : Create a folder
		' Input   : string	: sPath	: Path to folder
		' Return  : integer	: False : folder creation error
    	'					  True  : folder successfully created
		'**********************************************************************************
		On Error Resume next
		sFolder = vbnullString
		
		Dim currentSub : currentSub = "Class Helper:FolderCreate"
		
		'Get the starting point
		sFolder = Left(sPath, InStrRev(sPath, "\")-1)
		
		'Check and create the folder tree
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Checking if folder exists: " & sFolder
		If oFso.FolderExists(sFolder) Then
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating folder: " & sPath
			ofso.CreateFolder(sPath)
			If Err.number <> 0 Then
				UserLog.LogEvent ERRORL, "[" & currentSub & "] Error creating: " & sPath & ". The error was: " & Err.description
				FolderCreate = false
				Exit Function
			Else 
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Created Folder: " & sPath
				FolderCreate = true 
			End If
		Else 
			FolderCreate = False
		End If
	End Function
	
	Function FolderCreateRec(sPath)
		'**********************************************************************************
		' Purpose : Create the full folder Recursive
		' Input   : string	: sPath	: Path to folder
		' Return  : integer	:  -1 : folder creation error
		'						0 : folder allready exists
		'						1 : folder successfully created
		'**********************************************************************************
		On Error Resume next
		sFolder = vbnullString
		
		Dim currentSub : currentSub = "Class Helper:FolderCreateRec"
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Start creating directory structure: " & sPath

		'Find the starting point
		sFolder = sPath
		Do until oFso.FolderExists(sfolder)
			sFolder = Left(sFolder, InStrRev(sFolder, "\")-1)
		loop
		
		'Check and create the folder tree
		Do Until sFolder = sPath
			sFolder = Left(sPath, InStr(Len(sFolder) + 1, sPath & "\", "\"))
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Checking if folder exists: " & sFolder
			If Not oFso.FolderExists(sFolder) Then
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating folder: " & sFolder
				ofso.CreateFolder(sFolder)
				If Err.number <> 0 Then
					UserLog.LogEvent ERRORL, "[" & currentSub & "] Error creating: " & sFolder & ". The error was: " & Err.description
					FolderCreateRec = false
					Exit Function
				Else 
					FolderCreateRec = true 
				End If
			Else 
				FolderCreateRec = true
			End If
		Loop
		FolderCreateRec = true
	End Function
	
	Function FolderDeleteEmpty(Spath,sRootPath)
		'**********************************************************************************
		' Purpose : Delete empty Folders
		'**********************************************************************************
		Dim sTmpFolder
		On error Resume next
		
		Set oFolder = oFso.getFolder(Spath)
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Error Deleting: " & sTmpFolder & ". The error was: " & Err.description
			FolderDeleteEmpty = false
			Exit Function
		End If
	
		'Check and Delete the folder tree
		Do Until LCase(oFolder.path) = LCase(sRootPath)
					
			If oFolder.subFolders.count = 0 Then
				'UserLog.LogEvent INFORMATION, "[" & currentSub & "] Deleting folder: " & oFolder.path
				sTmpFolder = oFolder.path
				Set oFolder = oFolder.ParentFolder
				ofso.DeleteFolder(sTmpFolder)
				If Err.number <> 0 Then
					UserLog.LogEvent ERRORL, "[" & currentSub & "] Error Deleting: " & sTmpFolder & ". The error was: " & Err.description
					FolderDeleteEmpty = false
					Exit Function
				Else 
					FolderDeleteEmpty = true 
				End If
			Else 
				FolderDeleteEmpty = True
				Exit do
			End If
		Loop
	End Function
	
	function ReadFileLine(sPath, iLine)
		'**********************************************************************************
		' Purpose : Read a line from a text file
		' Input   : String : sPath : path to file
		'			integer : iLine : the line number to read
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:ReadFileLine"
		
		On Error Resume Next
		Err.clear
		
		If Helper.FileExists(sPath,False) Then
			aResult = Split(oFso.OpenTextFile(sPath,1).ReadAll,vbCRLF)
			
			'Just logging
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Read Output: "
			For iCnt = 0 To UBound(aResult)
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] -" & aResult(iCnt)
			Next

			If (iLine <= UBound(aResult)) Then
				ReadFileLine = aResult(iLine-1)
			End If
		End if		
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to Read File: " & sPath & ". The error was: " & Err.description & " (" & Err.number & ")"
		End If
	End Function
	
	Function ReadFile(sPath)
		'**********************************************************************************
		' Purpose : Read a text file
		' Input   : String : sPath : path to file
		'
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:ReadFile"
		
		On Error Resume Next
		Err.clear
		
		If Helper.FileExists(sPath,False) Then
			ReadFile = oFso.OpenTextFile(sPath,1).ReadAll
			
			'Just logging
			'UserLog.LogEvent INFORMATION, "[" & currentSub & "] Read Output: "
			'UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & ReadFile
		End if		
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to Read File: " & sPath & ". The error was: " & Err.description & " (" & Err.number & ")"
		End If
	End Function
	
	Function FileDelete(sPath)
		'**********************************************************************************
		' Purpose : Delete file
		' Input   : String : sPath : path to file
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:FileDelete"
		
		'On Error Resume Next
		'Err.clear
		
		oFso.DeleteFile sPath, True
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to delete File: " & sPath & ". The error was: " & Err.description & " (" & Err.number & ")"
			FileDelete = False
		Else
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Deleted File: " & sPath 
			FileDelete = True 
		End If
	End Function
	
	Sub FolderDelete(sPath)
		'**********************************************************************************
		' Purpose : Delete folder
		' Input   : String : sPath : path to folder
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:FolderDelete"
		
		On Error Resume Next
		Err.clear
		
		oFso.DeleteFolder sPath, True
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to delete Folder: " & sPath & ". The error was: " & Err.description & " (" & Err.number & ")"
			FolderDelete = False 
		Else
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Deleted Folder: " & sPath 
			FolderDelete = True
		End If
	End Sub
	
	Function GetDayTimeDate()
		'**********************************************************************************
		' Purpose : Get Day,Date,Time
		' Input   : None
		' Return  : Current day of week + Date + Time
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:GetDayTimeDate"
		
		GetDayTimeDate = WeekdayName(Weekday(Now, vbUseSystemDayOfWeek),,vbUseSystemDayOfWeek) & " " & Date & " "
		
		intSeconds = (Hour(Now) * 3600) + (Minute(Now) * 60) + Second(Now) 
        intMilliseconds = Timer() - intSeconds 
        'intMilliseconds = Fix(intMilliseconds * 100) 
        intMilliseconds = Fix(intMilliseconds * 10000) 
		
		If CInt(Hour(Now)) < 10 Then
			GetDayTimeDate = GetDayTimeDate & "0" & Hour(Now) & "."
		Else
			GetDayTimeDate = GetDayTimeDate & Hour(Now) & "."
		End If
		
		If CInt(Minute(Now)) < 10 Then
			GetDayTimeDate = GetDayTimeDate & "0" & Minute(Now) & "."
		Else
			GetDayTimeDate = GetDayTimeDate & Minute(Now) & "."
		End If
		
		If CInt(Second(Now)) < 10 Then
			GetDayTimeDate = GetDayTimeDate & "0" & Second(Now)
		Else
			GetDayTimeDate = GetDayTimeDate & Second(Now)
		End If
		
		If InStr(GetDayTimeDate, "/") Then
			GetDayTimeDate = Replace(GetDayTimeDate, "/", ".")
		End If
		If InStr(GetDayTimeDate, "\") Then
			GetDayTimeDate = Replace(GetDayTimeDate, "\", ".")
		End If
		
		GetDayTimeDate = GetDayTimeDate & "_" & intMilliseconds
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating Date " & GetDayTimeDate
	End Function
	
	Function Random(iValue)
		'**********************************************************************************
		' Purpose : Create a random integer between 0 and i
		' Input   : integer		: iValue	: The max value
		' Return  : integer		: Random number between 0 and Input (i)
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:Random"
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating a random integer between: 0-" & iValue
		
		'Generate seed
		Randomize
		iInt = Int(iValue * Rnd)
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Random integer is: " & iInt
		Random = iInt
	End Function
	
	Sub Terminate()
		'**********************************************************************************
		' Puropose : Terminate the script, moving log to error directory.
		'            Inform the user about the error.
		' Input    : None
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:Terminate"
		
		UserLog.LogEvent ERRORL, "[" & currentSub & "] ABORT."
		WScript.quit
	End Sub
	
	Function HTMLDecode(byVal sText) 
		'**********************************************************************************
		' Puropose : Replace all special HTML Codes 
		' Input    : string : sText : the text to process
		' output   : string : the cleaned string
		'**********************************************************************************
	    Dim regEx : Set regEx= New RegExp
	    Dim matches, match 

	    'replace common HTML codes
	    sText = Replace(sText, "&Agrave;"	,Chr(192))
	    sText = Replace(sText, "&agrave;"	,Chr(224))
	    sText = Replace(sText, "&Aacute;"	,Chr(193))
	    sText = Replace(sText, "&aacute;"	,Chr(225))
	    sText = Replace(sText, "&Acirc;" 	,Chr(194))
	    sText = Replace(sText, "&acirc;" 	,Chr(226))
	    sText = Replace(sText, "&Atilde;"	,Chr(195))
	    sText = Replace(sText, "&atilde;"	,Chr(227))
	    sText = Replace(sText, "&Auml;"		,Chr(196))
	    sText = Replace(sText, "&auml;"		,Chr(228))
	    sText = Replace(sText, "&Aring;"	,Chr(197))
	    sText = Replace(sText, "&aring;"	,Chr(229))
	    sText = Replace(sText, "&AElig;"	,Chr(198))
	    sText = Replace(sText, "&aelig;"	,Chr(230))
	    
	    sText = Replace(sText, "&Ccedil;"	,Chr(199))
	    sText = Replace(sText, "&ccedil;"	,Chr(231))
	    
	    sText = Replace(sText, "&ETH;"		,Chr(208))
	    sText = Replace(sText, "&eth;"		,Chr(240))
	    sText = Replace(sText, "&Egrave;"	,Chr(200))
	    sText = Replace(sText, "&egrave;"	,Chr(232))
	    sText = Replace(sText, "&Eacute;"	,Chr(201))
	    sText = Replace(sText, "&eacute;"	,Chr(233))
	    sText = Replace(sText, "&Ecirc;"	,Chr(202))
	    sText = Replace(sText, "&ecirc;"	,Chr(234))
	    sText = Replace(sText, "&Euml;"		,Chr(203))
	    sText = Replace(sText, "&euml;"		,Chr(235))
	    
	    sText = Replace(sText, "&Igrave;"	,Chr(204))
	    sText = Replace(sText, "&igrave;"	,Chr(236))
	    sText = Replace(sText, "&Iacute;"	,Chr(205))
	    sText = Replace(sText, "&iacute;"	,Chr(237))
	    sText = Replace(sText, "&Icirc;"	,Chr(206))
	    sText = Replace(sText, "&icirc;"	,Chr(238))
	    sText = Replace(sText, "&Iuml;"		,Chr(207))
	    sText = Replace(sText, "&iuml;"		,Chr(239))

	    sText = Replace(sText, "&Ntilde;"	,Chr(209))
	    sText = Replace(sText, "&ntilde;"	,Chr(241))

	    sText = Replace(sText, "&Ograve;"	,Chr(210))
	    sText = Replace(sText, "&ograve;"	,Chr(242))
	    sText = Replace(sText, "&Oacute;"	,Chr(211))
	    sText = Replace(sText, "&oacute;"	,Chr(243))
	    sText = Replace(sText, "&Ocirc;"	,Chr(212))
	    sText = Replace(sText, "&ocirc;"	,Chr(244))
	    sText = Replace(sText, "&Otilde;"	,Chr(213))
	    sText = Replace(sText, "&otilde;"	,Chr(245))
	    sText = Replace(sText, "&Ouml;"		,Chr(214))
	    sText = Replace(sText, "&ouml;"		,Chr(246))
	    sText = Replace(sText, "&Oslash;"	,Chr(216))
	    sText = Replace(sText, "&oslash;"	,Chr(248))
	    sText = Replace(sText, "&OElig;"	,ChrW(338))
	    sText = Replace(sText, "&oelig;"	,ChrW(339))
	    
		sText = Replace(sText, "&szlig;"	,Chr(223))
		sText = Replace(sText, "&THORN;"	,Chr(222))
		sText = Replace(sText, "&thorn;;"	,Chr(254))

	    sText = Replace(sText, "&Ugrave;"	,Chr(217))
	    sText = Replace(sText, "&ugrave;"	,Chr(249))
	    sText = Replace(sText, "&Uacute;"	,Chr(218))
	    sText = Replace(sText, "&uacute;"	,Chr(250))
	    sText = Replace(sText, "&Ucirc;"	,Chr(219))
	    sText = Replace(sText, "&ucirc;"	,Chr(251))
	    sText = Replace(sText, "&Uuml;"		,Chr(220))
	    sText = Replace(sText, "&uuml;"		,Chr(252))
	    
	    sText = Replace(sText, "&Yacute;"	,Chr(221))
	    sText = Replace(sText, "&yacute;"	,Chr(253))
	    sText = Replace(sText, "&Yuml;"		,Chr(159))
	    sText = Replace(sText, "&yuml;"		,Chr(255))
	    
		sText = Replace(sText, "&ndash;"	,Chr(45))
	    sText = Replace(sText, "&quot;"		,Chr(34)) 
	    sText = Replace(sText, "&lt;"  		,Chr(60)) 
	    sText = Replace(sText, "&gt;"  		,Chr(62)) 
	    sText = Replace(sText, "&amp;" 		,Chr(38)) 
	    sText = Replace(sText, "&nbsp;"		,Chr(32)) 
	 	 
	    'Replace dcimal codes
	    With regEx 
	     .Pattern = "&#(\d+);"
	     .Global = True 
	    End With 
	 
	    Set matches = regEx.Execute(sText) 
	    For Each match in matches 
	        sText = Replace(sText, match.Value, ChrW(match.SubMatches(0))) 
	    Next 
	 
	 	'Replace HEX codes
	    With regEx 
	     .Pattern = "&#x([A-Fa-f0-9]{2});"
	     '.Pattern = "&#x(\d+);" 
	     .Global = True 
	    End With 
	 
	    Set matches = regEx.Execute(sText) 
	    For Each match in matches 
	        sText = Replace(sText, match.Value, ChrW(CLng("&H" & match.SubMatches(0)))) 
	    Next 

	    HTMLDecode = Trim(sText) 
	End Function 

	Function MatchRegEx (sSearchData, sPattern, iMatchGroup, bMatchFirstOnly)
	'********************************************************************************
	' Puropose 	: Extract data Using the RegEx object
	' Input    	: string : sSearchData : The Data to be searched through
	'			  string : sPattern : The Pattern to search for
	'			  integer: iMatchGroup : The group number to return
	'			  boolean: bMatchFirstOnly : Return the first match or all matches
	' Output    : string/Array : The matched results
	'********************************************************************************
	Dim currentSub : currentSub = "Class Helper:MatchRegEx"
	'UserLog.LogEvent SUCCESS, "[" & currentSub & "]Checking Release : " & sRelease
	
	Dim Matches, Match, ResultArray()
	Dim regEx : Set regEx = New RegExp
	
	regEx.IgnoreCase 	= True   ' Set case insensitivity.
    regEx.Global 		= True   ' Set global applicability.
    regEx.Multiline		= True   ' Set global applicability. 
	regEx.Pattern 		= sPattern
	
	Set Matches = regEx.Execute(sSearchData)

	If bMatchFirstOnly =  True Then
		If Matches.Count > 0 Then
			Set Match = Matches.Item(0)
			If (Match.SubMatches.Count >= iMatchGroup) and (iMatchGroup <> -1) Then
				MatchRegEx = Trim(HTMLDecode(Match.SubMatches.Item(iMatchGroup-1)))
			Else 
				MatchRegEx = Trim(HTMLDecode(Match.Value))
			End If
		Else
			MatchRegEx = vbNullString 
		End If
		
	
	Else 'return all matches
		If Matches.Count > 0 Then
			For Each Match In Matches
				'return the sepcified group
				If Helper.GetSize(ResultArray) = 0 Then
					ReDim ResultArray(0)
				Else
					ReDim Preserve ResultArray(UBound(ResultArray)+1)
				End If 	
			
				If (Match.SubMatches.Count >= iMatchGroup) and (iMatchGroup <> -1) Then					
					ResultArray(UBound(ResultArray)) = HTMLDecode(Match.SubMatches.Item(iMatchGroup-1))
				Else
					ResultArray(UBound(ResultArray)) = HTMLDecode(Match.Value)
				End If
			Next
			MatchRegEx = ResultArray
		Else
			MatchRegEx = Array()
		End if
	End If
	
	Set regEx = Nothing
	End Function
	
	Function BreakString (ByVal str, ByVal str2, length, fillSpaces) 
		'********************************************************************************
		' Purpose	: Break up a string into multiline string having a given length
		' Input   	: string  : str		  : the input string
		'			  string  : str2      : the input string to append at the end
		'			  integer : length	  : the desired final length
		' 			  bool	  : fillSpaces: option to fill spaces
		'********************************************************************************
		Dim currentSub : currentSub = "Class Helper:BreakString"
		
		'fill with spaces
		ReDim aResult(0)
		
		iCnt = 0
		'process the main string
		While (Len(str) > length) 
			iWordBreak = InStrRev(str, " ", length)
			'force a break if no word break detected
			If (iWordBreak = 0) Or (iWordBreak < length/2) Then
				iWordBreak = length
			End If
			ReDim Preserve aResult(iCnt)
			aResult(iCnt) = Left(str, iWordBreak)
			str = Trim(Right(str,Len(str)-iWordBreak))
			iCnt = iCnt + 1
		Wend
		'check if the remaining string can accept the append of str2
		If (Len(str)+Len(str2)+1 >length) Then
			ReDim Preserve aResult(iCnt)
			aResult(iCnt) = str
			If (Len(Trim(str2))> 0) Then
				ReDim Preserve aResult(iCnt+1)
				If fillSpaces Then
					aResult(iCnt+1) = Space(length - Len(str2)) & str2
				Else
					aResult(iCnt+1) = str2
				End If
			End If
		Else
			ReDim Preserve aResult(iCnt)
			If fillSpaces Then
				aResult(iCnt) = str & Space(length - Len(str)- Len(str2)) & str2
			Else
				If (Len(str2) > 0) Then
					aResult(iCnt) = str & Space(1) & str2
				Else	
					aResult(iCnt) = str
				End If
			End If
		End If
		BreakString = aResult
	End Function
	
	Function BuildString (str, length)
		'********************************************************************************
		' Purpose : fill up a string with space to a given length
		' Input   : string	: str		: the input string
		'			integer : length	: the desired final length
		'********************************************************************************
		Dim currentSub : currentSub = "Class Helper:BuildString"
		
		'fill with spaces
		iCurrentLenth = Len(str)
		str = str & Space(length - iCurrentLenth)
		
		buildString = str
	End Function
	
	Function ExecTime(StartTime,EndTime)
		'**********************************************************************************
		' Puropose : build a string in format xxh xxm xxs
		' Input    : start time / end time
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:BuildTime"
		Dim iHour, iMinute, iSecond, iTotSeconds, endSeconds, startSeconds
	
		startSeconds = (Second(StartTime) + (Minute(StartTime) * 60) + ((Hour(StartTime) * 60)*60))
		endSeconds = (Second(EndTime) + (Minute(EndTime) * 60) + ((Hour(EndTime) * 60)*60))
		iTotSeconds = endSeconds - startSeconds 
		
		iHour     = Fix(iTotSeconds/3600)
		iMinute   = Fix((iTotSeconds - iHour*3600)/60)
		iSecond   = Fix(iTotSeconds - iMinute*60 - iHour*3600)
		
		ExecTime = iHour & "h " & iMinute & "m " & iSecond & "s "
	End Function 

	Function KeepOnly (sPath, iCount, iType)
		'**********************************************************************************
		' Purpose : Delete obsolete folders based upon creation date.
		'           n newest files are kept.
		' Input   : String (s) Path to root of folders
		'           Integer : iCount : Number of folders to keep
		'			Integer	: iType : 0 Files
		'							  1 Folders
		'							  2 Junctions
		'**********************************************************************************
		'On Error Resume Next
		On Error GoTo 0
		
		Dim currentSub : currentSub = "Class Helper:KeepOnly"
		
		Set oFldr = oFso.GetFolder(sPath)
		Helper.EchoErr Err, currentSub
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] An Error occured connecting to: " & sPath 
			KeepOnly = vbNull
			Exit function
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Connected to: " & sPath
		End If
		
		'Switch Folder or file Mode
		Select Case (iType)
			Case 0
				sType = "File"
				Set cCollection = oFldr.Files
				Helper.EchoErr Err, currentSub
			Case 1
				sType = "Folder"
				Set cCollection = oFldr.SubFolders
				Helper.EchoErr Err, currentSub
			Case  2
				sType = "Junction"
				Set cCollection = oFldr.SubFolders
				Helper.EchoErr Err, currentSub
		End Select
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] An Error occured while listing " & sType & " in folder: " & sPath & ". Old " & sType & " must be deleted manually."
			KeepOnly = vbNull 
			Exit function
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Succsessfully listed " & sType & " in folder: " & sPath
		End If
		
		'Check if number of files greater than i
		If cCollection.Count <= iCount Then
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Number of " & sType & " in root is: " & cCollection.Count & ". Number is less or equal to: " & iCount & " wich is the number of " & sType & " to keep."
			KeepOnly = vbNull 
			Exit function
		End If
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Number of " & sType & " in root is: " & cCollection.Count & ". Number is greater: " & iCount & " wich is the number of " & sType & " to keep."
		
		'ReDim array to number of folders
		ReDim aDate(cCollection.Count -1)
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating array with fixed size: " & cCollection.Count -1 & ". Adding date of " & sType & " to array"
		
		iCnt = 0
		
		'Add date creation of all objects to array
		For Each oObject In cCollection
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & oObject.DateCreated & " (Path: " & oObject.Path & ")"
			aDate(iCnt) = Array(oObject.DateCreated,oObject)
			iCnt = iCnt + 1
		Next
		
		'Sorting array by date, ascent sort order (The famous bubble sort)
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Sorting dates in array, ascent sort order"
		For n = 0 To UBound(aDate) -1 
			For m = n+1 To UBound(aDate) 
				If aDate(m)(0) < aDate(n)(0) Then
					temp = aDate(m)
					aDate(m) = aDate(n)
					aDate(n) = temp
				End If
			Next
		Next
		
		'Just logging
'		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Array sorted, result in ascent order: "
'		For iCnt = 0 To UBound(aDate)
'			UserLog.LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt)(0) & " (Path: " & aDate(iCnt)(1).Path & ")"
'		Next
		
		'Cut array, keep (i) rows with date of folders wich is going to be deleted
		ReDim Preserve aDate(UBound(aDate) - iCount)
		ReDim aDeleted (UBound(aDate))
'		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Array aDate cut, remaing rows are: "
		
		'Even more logging (those debuggers ;))
'		For iCnt = 0 To UBound(aDate)
'			UserLog.LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt)(0) & " (Path: " & aDate(iCnt)(1).Path & ")"
'		Next
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Start deleting " & sType & "..."
		For iCnt2 = 0 To UBound(aDate)
			aDeleted (iCnt2)	= aDate(iCnt2)(1).Name
			Select Case (sType)
				Case "File"
					Helper.FileDelete aDate(iCnt2)(1).Path
				Case "Folder"
					Helper.FolderDelete aDate(iCnt2)(1).Path
				Case "Junction"
					Junction.DeleteJunction aDate(iCnt2)(1).ParentFolder.Path , aDate(iCnt2)(1).Name
			End Select
		Next
		
		Helper.EchoErr Err, currentSub
		
		If Err.Number = 0 Then
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Deleted " & UBound(aDate)+1 & " obsolete " & sType & " Entries." 
		End If
		
		KeepOnly = aDeleted
	End function
End Class

'######################################################################################
' Class Wrapper for RaidenFTPD Command Processor
'######################################################################################
Class CmdProcessorClass

	'local vars
	public bAllowed, aAllowedVFS, sAllowedVFS, sDeniedVFS, aDeniedVFS, aTargetItem

	Sub CommandDispatcher()
		'********************************************************************************
		' Puropose : Dispatch the command
		' Input    : None (context parameters are passed through the main program)
		'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:CommandDispatcher"
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] Command Dispatcher Started"
		
		'Simple verification that the FTPD process is initiating the command in a way we expect
		Select Case LCase(cmdSITECMD)
			Case "imdb"
				' Nothing to check
			Case "fileuploaded"
				'Check the directory ignore list for system events
				if (Helper.Validate(cmdITEM,split(DIR_IGNORELIST,"|"))) then
					UserLog.LogEvent SUCCESS, "[" & currentSub & "] [" & cmdITEM & "] was IGNORED (DIR Ignore list)."
					WScript.Quit
				End If
			Case "newdir"
				'Check the directory ignore list for system events
				if (Helper.Validate(cmdITEM,split(DIR_IGNORELIST,"|"))) then
					UserLog.LogEvent SUCCESS, "[" & currentSub & "] [" & cmdITEM & "] was IGNORED (DIR Ignore list)."
					WScript.Quit
				End If
			
			Case Else
				UserLog.LogEvent ERRORL, "[" & currentSub & "] FTPD or this installation has been tamper with. " & cmdSITECMD & " is not a valid command."
				WScript.Quit
		End Select
		
		'Check if user has requested help
		If LCase(cmdEVENT) = "help" Or LCase(cmdEVENT) = "-h" Or LCase(cmdEVENT) = "-help" Then
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] User has requested help, call TerminateInHlp()"
			TerminateInHlp
		End If
		
		'Check if the path is allowed
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Virtual path ALLOW Check..."
		bAllowed = False
		If cmdTYPE = "user" then
			aAllowedVFS = Split(IMDB_ALLOWED_VFS, "|")
		Else
			aAllowedVFS = Split(IMDB_EVENT_ALLOWED_VFS, "|")
		End If
		
		For Each sAllowedVFS In aAllowedVFS
			If InStr(LCase(Left(cmdVIRTUALPATH,Len(sAllowedVFS))), LCase(sAllowedVFS)) Then
				bAllowed = True 
			End If
		Next
		If bAllowed = False Then
			TerminateInMsg currentSub,ERRORL, "Virtual path '" & cmdVIRTUALPATH & "' is NOT Allowed to IMDB commands."
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Virtual path '" & cmdVIRTUALPATH & "' IS Allowed to IMDB commands."
		End If 
		
		'Check if the path is disallowed
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Virtual path DENY Check..."
		bAllowed = true 
		If cmdTYPE = "user" then
			aDeniedVFS = Split(IMDB_DENIED_VFS, "|")
		Else
			aDeniedVFS = Split(IMDB_EVENT_DENIED_VFS, "|")
		End If
	
		For Each sDeniedVFS In aDeniedVFS
			If InStr(LCase(Left(cmdVIRTUALPATH,Len(sDeniedVFS))), LCase(sDeniedVFS)) Then
				bAllowed = False  
			End If
		Next
		If bAllowed = False  Then
			TerminateInMsg currentSub,ERRORL, "Virtual path '" & cmdVIRTUALPATH & "' IS Denied to IMDB commands."
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Virtual path '" & cmdVIRTUALPATH & "' is NOT Denied to IMDB commands."
		End If 
		
		'Check path and resolve the real folder
		 aTargetItem = RaidenVFSFile.GetRealObject (cmdVIRTUALPATH, cmdITEM)
		'Check if it was found
		If Not(UBound(aTargetItem) > 0) Then
			TerminateInMsg currentSub,ERRORL, "Unable to find '" & Replace(cmdITEM,"%","%%") & "'. Please contact an SysOp."
		End If 
		
		'Check and apply the Options overload
		VerifyOptions cmdEVENT,cmdITEM,cmdOPTIONS 
		
		'Check if user has requested imdb info
		If LCase(cmdEVENT) = "getinfo" Or LCase(cmdEVENT) = "-getinfo" Then
			If (((IMDB_OPS_ONLY = True) And (cmdLevel = 1)) Or (IMDB_OPS_ONLY = False)) Then
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] User is requesting IMDB Info, call TerminateInGetInfo()"
				
				If (aTargetItem(2) = "File" Or Helper.Validate(cmdITEM,split(DIR_IGNORELIST,"|")) ) Then
					TerminateInMsg currentSub, ERRORL, "Please select a valid Release. " & cmdITEM & " is not a valid release."
				Else
					TerminateInGetInfo aTargetItem(0), aTargetItem(1)
				End if
			Else
				TerminateInMsg currentSub, INFORMATION, "User:" & cmdUSER & " does Not have access to 'Imdb' commands"
			End If
		End If
		
		'Check if user has requested poster
		If LCase(cmdEVENT) = "getposter" Or LCase(cmdEVENT) = "-getposter" Then
			If (((IMDB_OPS_ONLY = True) And (cmdLevel = 1)) Or (IMDB_OPS_ONLY = False)) Then
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] User is requesting IMDB poster, call TerminateInGetPoster()"
				
				If (aTargetItem(2) = "File" Or Helper.Validate(cmdITEM,split(DIR_IGNORELIST,"|")) ) Then
					TerminateInGetPoster Left(aTargetItem(0), InStrRev(aTargetItem(0),"\") -1), Right(aTargetItem(0), Len(aTargetItem(0)) - InStrRev(aTargetItem(0),"\"))
				Else
					TerminateInGetPoster aTargetItem(0), aTargetItem(1)
				End if
			Else
				TerminateInMsg currentSub, INFORMATION, "User:" & cmdUSER & " does Not have access to 'Imdb' commands"
			End If
		End If
		
		'If we get here it means that the command was not recognized
		UserLog.LogEvent ERRORL, "[" & currentSub & "] User requested : Unknown Command : [" & cmdEVENT & "]. call TerminateInHlp()"
		TerminateInHlp
	End Sub
	
	Public Function VerifyOptions(sCommand, aItem, aOptions)
		'********************************************************************************
		' Purpose : Verify the provided options
		' Input   : sCommand, aItem, aOptions
		'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:VerifyOptions"
		Dim sModifier, tmpModifier
		
		If TypeName(aOptions) = "Empty" Then
			Exit function
		End If
		
		'On Error Resume Next
		For Each sModifier In aOptions
			Select Case LCase(Left(sModifier,4))
				Case "-id:"
					tmpModifier = Replace(sModifier,"-id:",vbNullString)
					If Helper.MatchRegEx (tmpModifier,"^(\d{7})$",1,True) <> vbNullString then
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] User Forced IMDB id: " & tmpModifier
						DEF_IMDB_ID = tmpModifier
					Else
						UserLog.LogEvent ERRORL, "[" & currentSub & "] User tried to force unknown Imdb-ID format (" & sModifier & "). The option was ignored"
					End If
				Case "-is:"	
					tmpModifier = Replace(sModifier,"-is:",vbNullString)
					Select Case LCase(tmpModifier)
						Case "false"
							DEF_FILE_SAVE = False 
							UserLog.LogEvent INFORMATION, "[" & currentSub & "] User Disabled Imdb Information file save"
						Case "true"
							DEF_FILE_SAVE = True
							UserLog.LogEvent INFORMATION, "[" & currentSub & "] User Enabled Imdb Information file save"
						Case Else
							UserLog.LogEvent ERRORL, "[" & currentSub & "] User requested unknown option ("& sModifier & "). The option was ignored"
					End Select 
				Case "-pd:"	
					tmpModifier = Replace(sModifier,"-pd:",vbNullString)
					Select Case LCase(tmpModifier) 
						Case "false"
							DEF_POSTER_DOWNLOAD = False 
							UserLog.LogEvent INFORMATION, "[" & currentSub & "] User Disabled Poster download"
						Case "true"
							DEF_POSTER_DOWNLOAD = True
							UserLog.LogEvent INFORMATION, "[" & currentSub & "] User Enabled Poster Download"
						Case Else
							UserLog.LogEvent ERRORL, "[" & currentSub & "] User requested unknown option ("& sModifier & "). The option was ignored"
					End Select 	
				Case "-ps:"
					tmpModifier = Replace(sModifier,"-ps:",vbNullString)
				
					If (TypeName(CInt(tmpModifier))= "Integer")Then
						DEF_POSTER_SIZE = CInt(tmpModifier)
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] User forced " & DEF_POSTER_SIZE & " pixels"
					Else
						UserLog.LogEvent ERRORL, "[" & currentSub & "] User requested unknown option ("& sModifier & "). The option was ignored"
					End If 
					
				Case "-dbg"
					DEF_DEBUG = True
					UserLog.LogEvent ERRORL, "[" & currentSub & "] User requested Debug save of data files"					
				Case Else
					UserLog.LogEvent ERRORL, "[" & currentSub & "] User requested unknown option (" & sModifier & "). The option was ignored"
			End Select
		Next 
	End Function

	Function GetImdbID (sReleasePath)
	'********************************************************************************
	' Puropose 	: Get the IMDB ID
	' Input    	: string : sReleasePath : The full path to the release
	' Output    : string : the Matched IMDB ID
	'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:GetImdbID"
		
		Dim Http: Set Http = New HTTPClass 
		Dim ReleaseName, CleanReleaseName, ReleasePath, nfoFile, sPattern, files, file, ReqSeason, ReqEpisode
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "]Checking Release : " & sReleasePath
		
		'Seperate path & release name
		ReleasePath = Left(sReleasePath, InStrRev(sReleasePath,"\")-1)
		ReleaseName = Right(sReleasePath, Len(sReleasePath)-InStrRev(sReleasePath,"\"))
		
		'First try to extract id from nfo file
		files = Helper.GetFolderContent(sReleasePath, false,  "*.nfo")
		
		For Each file In files
			If file <> IMDB_FILE_NAME Then
				UserLog.LogEvent SUCCESS, "[" & currentSub & "]Reading NFO File : " & sReleasePath & "\" & File
				
				sPattern 	= ".+?[www|us]\.imdb.+?/title[/tt|?].*([0-9]{7})[/| ]"	
				GetImdbID = Helper.MatchRegEx (Helper.ReadFile(sReleasePath & "\" & File), sPattern,1,True)
				
				If GetImdbID <> vbNullString  Then
					UserLog.LogEvent INFORMATION, "[" & currentSub & "]Found ImdbID : " & GetImdbID
					Exit function
			    Else
			    	UserLog.LogEvent INFORMATION, "[" & currentSub & "]Unable to find ImdbID in : " & File
			    End If
			Else
				GetIMDBid = vbNullString
			   	UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & IMDB_FILE_NAME &" file found is Ignored"
			End If
		Next
		
		'try google to resolve the release name
		If GetIMDBid = vbNullString Then
			UserLog.LogEvent INFORMATION, "[" & currentSub & "]Trying to google Imdb-ID : " & sReleasePath
			'strip out scene tags 
			CleanReleaseName = GetCleanRelease(ReleaseName)
	
			'Try google
			Dim page
			page = Http.GetURL ("http://www.google.com/search?hl=en&btnI=I%27m+Feeling+Lucky&as_sitesearch=www.imdb.com&q=[" & CleanReleaseName & "]")
			
			If Http.Status = 200 Then
			
				sPattern 	= ".+?www\.imdb.+?/title/tt.*([0-9]{7})[/| ]"	
				GetImdbID = Helper.MatchRegEx (page, sPattern, 1, True)
				If GetImdbID <> vbNullString  Then
					UserLog.LogEvent SUCCESS, "[" & currentSub & "]Google Found Release Imdb-ID : " & GetIMDBid
					If IMDB_GET_EPISODE_ID then
						'Check if user requested info on a TV Episode
						sPattern	 = ".+?\.S0?(\d{1,2})E0?(\d{1,2})\."
						ReqSeason  = Helper.MatchRegEx(ReleaseName, sPattern, 1, True)
						ReqEpisode = Helper.MatchRegEx(ReleaseName, sPattern, 2, True)
						If ReqSeason <> vbNullString And ReqEpisode <> vbNullString Then
							UserLog.LogEvent INFORMATION, "[" & currentSub & "]Looking for Episode Imdb-ID : " & CleanReleaseName & " : Season: " & ReqSeason & ", Episode: " & ReqEpisode
							'Get the episode page
							page = Http.GetURL ("http://www.imdb.com/title/tt" & GetImdbID & "episodes")
							If Http.Status = 200 Then
								sPattern 	= "<h3>Season " & ReqSeason & ", Episode " & ReqEpisode & ": <a href=" & Chr(34) & "/title/tt(\d{7})/" & Chr(34) & ">.+?</a></h3>"
								'Return the result
								If Helper.MatchRegEx (page,sPattern,1,True) <> vbNullString Then
									GetImdbID = Helper.MatchRegEx (page, sPattern, 1, True)
									UserLog.LogEvent INFORMATION, "[" & currentSub & "]Google Found Episode Imdb-ID : " & GetIMDBid
								Else
									UserLog.LogEvent INFORMATION, "[" & currentSub & "]Unable to find Episode Imdb-ID will use Series Imdb-ID"
								End If 
							Else
                				TerminateInMsg currentSub, ERRORL, Http.StatusText
                            End If 
						End If
					End if
			    Else
			    	UserLog.LogEvent ERRORL, "[" & currentSub & "]Unable to find Imdb-ID from google"
			    End If
			Else
				TerminateInMsg currentSub, ERRORL, Http.StatusText
			End if
		End if
	
		Set Http = Nothing 
	End function
	
	Function GetCleanRelease (sRelease)
		'********************************************************************************
		' Puropose 	: Extract the release name stripped from the scene tags
		' Input    	: string : sRelease : The full scene release name
		' Output    : string : the stripped release name
		'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:GetCleanRelease"
		UserLog.LogEvent SUCCESS, "[" & currentSub & "]Checking Release : " & sRelease
	
		Dim Matches, Match
		
		Dim regEx : Set regEx = New RegExp
		regEx.IgnoreCase 	= True   ' Set case insensitivity.
	    regEx.Global 		= True   ' Set global applicability.
	    regEx.Multiline		= True   ' Set global applicability. 
		
		regEx.Pattern 	= "(.+?)(\.|\-|_)(internal|directors|dir\.cut|festival|complete|scr|real\.repack|real\.custom|real\.proper|custom.+?sub|s\d\d|ps2dvd|ps2cd|gba|gbc|psp|xbox|gc|xbox360|ps3|wii|bluray|blu\-ray|hddvd|hdtv|pdtv|dsr|xvid|divx|cam|jav|extended|ee|se|special.+?edition|swe|dc|directors|director|unrated|pal|ntsc|multisubs|french|truefrench|danish|german|norwegian|swedish|nordic|multi|repack|stv|subbed|limited|dvdrip|720p|1080p|proper|dvdscr|scr|screener|ts|tc|telecine|telesync|tc|r[1-5]|xxx|s\d+|s\d+e\d+|s\d+d\d+|dvdr|mdvdr|m\-dvdr|1080i|ws|fs|us|fr|french|truefrench|danish|german|norwegian)(\.|\-|_)"
		
		Set Matches = regEx.Execute(sRelease)
	
		If Matches.Count > 0 Then
			Set Match = Matches.Item(0)
			If match.SubMatches.Count > 0 Then
				GetCleanRelease = Match.Submatches.Item(0)
				regEx.Pattern 	= "(\.|\-|_)"
				GetCleanRelease = regEx.Replace(GetCleanRelease, " ")
				UserLog.LogEvent SUCCESS, "[" & currentSub & "]Matched Release : " & GetCleanRelease
	    	Else
	    		GetCleanRelease = vbNullString
	    		UserLog.LogEvent ERRORL, "[" & currentSub & "]Unable to match Release : " & sRelease
	    	End If
		Else
			GetCleanRelease = vbNullString
			UserLog.LogEvent ERRORL, "[" & currentSub & "]Unable to match Release : " & sRelease
		End If
	End Function

	Public Function ChangeOwner(sMode, sUser, sGroup, sPath, sItem, bRecursive)
		'********************************************************************************
		' Purpose : change owner on file and folders (For raidenFTPD)
		' Input   : sMode	   : the mode in xxx format (ie: 744 or 777)
		'           sUser	   : the new owner (user)
		'           sGroup	   : the new owner (group)
		'           sPath      : The path where to start
		'		    sItem      : The Item
		'           bRecursive : Should the operation be recurcive [True|False]
		'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:ChangeOwner"
		Dim sCmdRun, oFolder, Folder
				
		sCmdRun = Chr(34) & SCRIPTPATH & "\tools\chmod.exe" & Chr(34)
		sCmdRun = sCmdRun & " " & IMDB_FILE_MODE & " " & cmdUSER & " " & cmdUSERGRP & " "
		Helper.ShellRun sCmdRun & Chr(34) & sPath & "\" & sItem & Chr(34),0,false,""
		'Helper.ShellRun sCmdRun & Chr(34) & sPath & "\" & IMDB_FILE_NAME & Chr(34),0,false,""
		
		If bRecursive Then
			Set oFolder = Helper.oFso.GetFolder(sItemPath)
			For each Folder in oFolder.Subfolders        
				ChangeOwner sMode, sUser, sGroup, Folder.Path, Folder.Name, bRecursive   
			Next
		End if 
	End Function
	
	Public Function ChangeDate(sItemPath, dDate, iDateProperty, bRecursive)
		'********************************************************************************
		' Purpose : change DateTime on file and folders
		' Input   : sItemPath     : The item path (Folder or File) 
		'           dDate         : the datetime to apply
		'           sDateProperty : 1:DateCreated|2:DateLastAccessed|3:Default:DateLastModified
		'           bRecursive    : Should the operation be recurcive [True|False]
		'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:ChangeDate"
		Dim sCmdRun
			
		sCmdRun = Chr(34) & SCRIPTPATH & "\tools\dirdate.exe" & Chr(34)
		
		If bRecursive Then 'set the recursivity 
			sCmdRun = sCmdRun & " -R"
		End if		
		
		Select Case iDateProperty 'select the dateTime property to set
			Case 1
				sCmdRun = sCmdRun & " -DATEFORMAT=dd/mm/yyyy CREATED=" 
			Case 2
				sCmdRun = sCmdRun & " -DATEFORMAT=dd/mm/yyyy LASTACCESS=" 
			Case else
				sCmdRun = sCmdRun & " -DATEFORMAT=dd/mm/yyyy MODIFIED=" 
		End select
		
		sCmdRun = sCmdRun & " date=" & Day(dDate) & "/" & Month(dDate) & "/" & Year(dDate) & " time=" & Hour(dDate) & ":" & Minute(dDate) & ":" & Second(dDate) & " "
		
		Helper.ShellRun sCmdRun & Chr(34) & sItemPath & Chr(34),0,false,""
	End Function
	
	Function MakeBAR(sPath, sBarType, sBarTemplate, sBarDelTemplate)
		'**********************************************************************************
		' Purpose : Build the bar
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:MakeBAR"
		Dim Matches, Match, sOutput, sValue
		Dim regEx : Set regEx = New RegExp
	
		On Error Resume Next 
		
		regEx.IgnoreCase 	= True   ' Set case insensitivity.
	    regEx.Global 		= True   ' Set global applicability.
	    regEx.Multiline		= True   ' Set global applicability. 
		regEx.Pattern 		= "%.+?%"
		
		Set Matches = regEx.Execute(sBarTemplate)
		
		sOutput = sBarTemplate
		For Each Match In Matches
			sValue = Eval("imdb." & Replace(Match.Value,"%",vbnullstring))
			'Fix lists
			sValue = Replace(sValue,", ","-")
			
			If Err.Number <> 0 Then
				UserLog.LogEvent ERRORL, "["& currentSub & "] The tag "& Match.Value & " does not exist"
				Err.Clear
			Else
				If sValue <> vbNullString Then
					If IMDB_TAG_SPACE = True Then
						sOutput = Replace(sOutput,Match.Value,sValue)
					Else
						sOutput = Replace(sOutput,Match.Value,Replace(sValue,Chr(32),Chr(95)))
					End If
				Else
					sOutput = Replace (sOutput,Match.Value,"Unknown")
				End If 
			End If
		Next
		sOutput = Helper.FixDirectoryName(sOutput)
		UserLog.LogEvent INFORMATION, "["& currentSub & "] The BAR Value is  " & sOutput
		
		Select Case LCase(sBarType)
			Case "file"
				Helper.FileDeletePattern sPath, sBarDelTemplate
				Helper.FolderDeletePattern sPath, sBarDelTemplate
				Helper.FileCreate sPath & "\" & sOutput	
			Case else
				Helper.FileDeletePattern sPath, sBarDelTemplate
				Helper.FolderDeletePattern sPath, sBarDelTemplate
				Helper.FolderCreate sPath & "\" & sOutput	
		End Select
		
		MakeBAR = sOutput 
	End Function
	
	Sub TerminateInHlp()
		'********************************************************************************
		' Puropose : Terminate the script, write help output to user
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:TerminateInHlp"
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] HELP Command Process Started"
		
		RaidenOutFile.WriteMsgHeader
		RaidenOutFile.WriteMsg "Syntax : site " & cmdSITECMD & " <command> <Release> <options>",1
		RaidenOutFile.WriteMsgSeperator
		RaidenOutFile.WriteMsg "Commands :",1
		
		If (((IMDB_OPS_ONLY = True) And (cmdLEVEL = 1)) Or (IMDB_OPS_ONLY = False)) Then
			'build the command help
			RaidenOutFile.WriteMsg "getinfo   <Release> [<Options>] : Get Imdb Information",4
			RaidenOutFile.WriteMsg "getposter <Release> [<Options>] : Download Imdb Poster",4
			RaidenOutFile.WriteMsg "help                            : Show this help",4
			RaidenOutFile.WriteMsgSeperator
			RaidenOutFile.WriteMsg "Options :",1
			RaidenOutFile.WriteMsg "-id:[xxxxxxx]    : Override the Imdb-ID detection",4
			RaidenOutFile.WriteMsg "-is:[true|false] : Force save Imdb data to folder",4
			RaidenOutFile.WriteMsg "-pd:[true|false] : Force poster download to folder",4
			RaidenOutFile.WriteMsg "-ps:[height]     : Force poster Height(px) (0=Max)",4
			RaidenOutFile.WriteMsg "",1
			RaidenOutFile.WriteMsgWithAppend "","defaults: -is:" & LCase(IMDB_FILE_SAVE) & " -pd:" & LCase(IMDB_POSTER_DOWNLOAD) & " -ps:" & IMDB_POSTER_SIZE,1
		Else 
			RaidenOutFile.WriteMsg "There are no commands availaible for user. ",4
		End If 	
		RaidenOutFile.WriteMsgTail False 
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] HELP Command Process Completed"	
		
		'terminate
		UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
		WScript.Quit
	End Sub
	
	Sub TerminateInGetInfo(sPath,sItem)
		'********************************************************************************
		' Puropose : Terminate the script, write help output to user
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:TerminateInGetInfo"
		Dim id, out, modifiedDate, sPattern, sBar
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] GetInfo Command Process Started"
		
		'check if ImdbID was forced
		If DEF_IMDB_ID <> vbNullString Then
			id = DEF_IMDB_ID
		Else
			'else try to fetch the id 
			id = GetIMDBid(sPath & "\" & sItem)
		End If 
		
		'Save the dates
		If IMDB_PRESERVE_DATE Then
			modifiedDate = Helper.GetFolderDate (sPath & "\" & sItem, 3)
		End If 
		
		If id <> vbNullString Then
			'Check and Set Season info
			sPattern	 = ".+?\.S0?(\d{1,2})\."
			IMDB.Season  = Helper.MatchRegEx(sItem, sPattern, 1, True)
			
			If IMDB.Season = vbNullString Then
				'Check and Set Season and Episode info
				sPattern	 = ".+?\.S0?(\d{1,2})E0?(\d{1,2})\."
				IMDB.Season  = Helper.MatchRegEx(sItem, sPattern, 1, True)
				IMDB.Episode = Helper.MatchRegEx(sItem, sPattern, 2, True)
			End If 
			
			'set debug
			IMDB.SaveDebugFile = DEF_DEBUG
			
			'Set and load the Imdb Data
			IMDB.ID      = id
			
			If IMDB.MediaLoaded = true Then
				'Build Imdb Output - START-
				'==========================
				RaidenOutFile.WriteMsgHeader
				If IMDB_FILE_ADD_DATE = True Then
					RaidenOutFile.WriteMsgWithAppend sItem, Date,1
				Else
					RaidenOutFile.WriteMsg sItem,1
				End If 
				RaidenOutFile.WriteMsgSeperator
				If IMDB_USE_ORIGINAL_TITLE = True And IMDB.TitleOriginal <> vbNullString Then 
					RaidenOutFile.WriteMsgWithAppend "Title   : " & IMDB.TitleOriginal, " Imdb-ID: " & IMDB.ID,1
				Else
					RaidenOutFile.WriteMsgWithAppend "Title   : " & IMDB.Title,         " Imdb-ID: " & IMDB.ID,1
				End if
				RaidenOutFile.WriteMsgWithAppend     "Genres  : " & IMDB.Genres,        " Rating: "  & IMDB.Rating,1
				RaidenOutFile.WriteMsgWithAppend     "Duration: " & IMDB.Duration,      " Country: " & IMDB.Countries,1
				if IMDB.MediaType = "TV" Or IMDB.MediaType = "TVEP" Then
				    RaidenOutFile.WriteMsgWithAppend "Dates   : " & IMDB.ReleaseDate,   " MPAA: "    & IMDB.MPAA,1
					If IMDB.Season <> vbNullString Then 
						RaidenOutFile.WriteMsg   "Season  : " & IMDB.Season,1
					Else
						RaidenOutFile.WriteMsg   "Seasons : " & IMDB.Seasons,1
					End If
				Else 
				RaidenOutFile.WriteMsgWithAppend "Released: " & IMDB.ReleaseDate,   " MPAA: "    & IMDB.MPAA,1
				
				End If 
				RaidenOutFile.WriteMsgSeperator
				If IMDB.MediaType = "Movie" Then
					RaidenOutFile.WriteMsg "Director: " & IMDB.Directors,1
				Else
					RaidenOutFile.WriteMsg "Creator : " & IMDB.Directors,1
				End If 
				RaidenOutFile.WriteMsg "Stars   : " & IMDB.Stars,1
				RaidenOutFile.WriteMsgSeperator
				'RaidenOutFile.WriteMsg "Desc    : " & IMDB.Description,1
				If IMDB.EpisodeLoaded Then
					RaidenOutFile.WriteMsg "Ep.Title    : " & IMDB.EpisodeTitle,1
					RaidenOutFile.WriteMsg "Ep.Air Date : " & IMDB.EpisodeAirDate,1
					RaidenOutFile.WriteMsg "Ep.Desc.    : " & IMDB.EpisodeDescription,1
					RaidenOutFile.WriteMsg "Ep.Link     : " & IMDB.EpisodeLink,1
				Else
					RaidenOutFile.WriteMsg "StoryLine: " & IMDB.StoryLine,1
					RaidenOutFile.WriteMsg "TagLine  : " & IMDB.TagLine,1
				End if 
				RaidenOutFile.WriteMsgSeperator
				If IMDB_ENABLE_OFFICIAL_LINKS = True And IMDB.OfficialLink <> vbNullString Then
					RaidenOutFile.WriteMsg "Off.Link: " & IMDB.OfficialLink,1
				End If 
				    RaidenOutFile.WriteMsg "Link    : " & IMDB.Link,1
				RaidenOutFile.WriteMsg "Media   : " & IMDB.MediaLink,1
				RaidenOutFile.WriteMsg "Poster  : " & IMDB.PosterLink,1
				RaidenOutFile.WriteMsgTail False
				UserLog.LogEvent SUCCESS, "[" & currentSub & "] Posted Response to User"	
				'==========================
				'Build Imdb Output - END-
											
				'Auto save imdb file
				If DEF_FILE_SAVE = True Then
					Helper.SavetoFile RaidenOutFile.ReadOutput(True), sPath & "\" & sItem & "\" & IMDB_FILE_NAME, 2, True
				End If
				
				'Build the BAR
				If (IMDB_ENABLE_BAR = True) Then
					Select Case IMDB.MediaType
						Case "TV"  
							sBar = CmdProcessor.MakeBAR (sPath & "\" & sItem, IMDB_BAR_TYPE, IMDB_TV_BAR, DEL_IMDB_TV_BAR)
						Case "TVEP"
							sBar = CmdProcessor.MakeBAR (sPath & "\" & sItem, IMDB_BAR_TYPE, IMDB_TV_BAR, DEL_IMDB_TV_BAR)
						Case "Movie"
							sBar = CmdProcessor.MakeBAR (sPath & "\" & sItem, IMDB_BAR_TYPE, IMDB_BAR, DEL_IMDB_BAR)
					End Select
				End If
			
				'Auto download imdb poster
				If (DEF_POSTER_DOWNLOAD = True) And (IMDB.PosterLink <> vbNullString) Then
					IMDB.GetPoster(sPath & "\" & sItem)
				End If
				
				'Change Owner and mode for BAR
				If IMDB_BAR_CHOWN Then
					'Change Bar
					If IMDB_ENABLE_BAR = True Then
						CmdProcessor.ChangeOwner IMDB_BAR_MODE, cmdUSER, cmdUSERGRP, sPath & "\" & sItem, sBar, False
					End If
				End if
				
				'Change Owner and mode for Files
				If IMDB_FILE_CHOWN Then
					If IMDB_POSTER_DOWNLOAD = True Then
						CmdProcessor.ChangeOwner IMDB_FILE_MODE, cmdUSER, cmdUSERGRP, sPath & "\" & sItem, IMDB_POSTER_NAME & ".jpg", False
					End If
					If IMDB_FILE_SAVE = True Then
						CmdProcessor.ChangeOwner IMDB_FILE_MODE, cmdUSER, cmdUSERGRP, sPath & "\" & sItem, IMDB_FILE_NAME, False
					End If
				End If
				
				'Reset the dates
				If IMDB_PRESERVE_DATE Then
					CmdProcessor.ChangeDate sPath & "\" & sItem, modifiedDate, 3, False
				End If 
			Else
				TerminateInMsg currentSub,ERRORL, "Unable to load IMDB Data. Please try again later."
			End If
		Else
			TerminateInMsg currentSub,ERRORL, "Unable to Identify Imdb-ID. Lookup the Imdb-ID on www.imdb.com and use option -id. "
		End if
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] GetInfo Command Process Completed"	
		
		'terminate
		WScript.Quit
	End Sub
	
	Sub TerminateInGetPoster(sPath, sItem)
		'********************************************************************************
		' Puropose : Download poster, write output to user
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:TerminateInGetPoster"
		Dim id, out, modifiedDate
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] GetPoster Command Process Started"
		
		'check if ImdbID was forced
		If DEF_IMDB_ID <> vbNullString Then
			id = DEF_IMDB_ID
		Else
			'else try to fetch the id 
			id = GetIMDBid(sPath & "\" & sItem)
		End If 
		
		'Save the dates
		If IMDB_PRESERVE_DATE Then
			modifiedDate = Helper.GetFolderDate (sPath & "\" & sItem, 3)
		End If 
		
		'set debug
		IMDB.SaveDebugFile = DEF_DEBUG
		
		If id <> vbNullString Then
			IMDB.ID = id
			If IMDB.MediaLoaded = true Then
				'verify if imdb has a poster
				If IMDB.PosterLink = vbNullString Then
					TerminateInMsg currentSub, ERRORL, "Unable to find poster on Imdb."
				End If 
				
				'Download the poster		
				If IMDB.GetPoster(sPath & "\" & sItem) Then
					'Change Owner and mode
					If IMDB_FILE_CHOWN Then
						CmdProcessor.ChangeOwner IMDB_FILE_MODE, cmdUSER, cmdUSERGRP, sPath & "\" & sItem, IMDB_POSTER_NAME & ".jpg", False
					End If
					
					'Reset the dates
					If IMDB_PRESERVE_DATE Then
						CmdProcessor.ChangeDate sPath & "\" & sItem, modifiedDate, 3, False
					End If 
					
					TerminateInMsg currentSub, SUCCESS, "Imdb poster was saved. Please refresh listing in your ftp client"
				Else
					TerminateInMsg currentSub, ERRORL, "Unable to save poster. Please try again later."
				End If 
			Else
				TerminateInMsg currentSub, ERRORL, "Unable to load Imdb Data. Please try again later."
			End If
		Else
			TerminateInMsg currentSub, ERRORL, "Unable to Identify Imdb-ID. Lookup the Imdb-ID on www.imdb.com and use option -id. "
		End if
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] GetPoster Command Process Completed"	
		
		'terminate
		WScript.Quit
	End Sub
	
	Sub TerminateInSysErr()
		'********************************************************************************
		' Puropose : Terminate the script
		'            Inform the user about the error.
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class CmdProcessorClass:TerminateInSysErr" 
		
		UserLog.LogEvent ERRORL, "[" & currentSub & "] " & ABORT
		PostMessage RaidenOutFile, "An internal system error has occured. The error has been logged, please report this error to system administrator."
		UserLog.LogEvent ERRORL, "[" & currentSub & "] Script Aborted"
		UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
		WScript.quit
	End Sub
	
	Sub TerminateInMsg(currentSub, ErrLevel ,sMessage)
		'********************************************************************************
		' Puropose : Terminate the script, write output message to user
		' Input    : string : sMessage : the message to post
		'********************************************************************************
		PostMessage RaidenOutFile, sMessage
		UserLog.LogEvent ErrLevel, "[" & currentSub & "] " & sMessage
		UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
		WScript.quit
	End Sub
	
	Sub PostMessage(oOutFile,sMessage)
		Dim currentSub : currentSub = "Class CmdProcessorClass:PostMessage"
		
		oOutFile.WriteMsgHeader
		oOutFile.WriteMsg sMessage,1
		oOutFile.WriteMsgTail False 
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] " & "Posted Message: " & sMessage
	End Sub
End Class

'#################################################################################
' Class Wrapper for Array Management
'#################################################################################
Class ArrayWrapper
	'Class vars
	Private  c_aArray(), c_iClassItems, c_sClassType, c_sClassName, c_oParent
	'Local vars
	Private bFound, iCnt, iSize, iGetSize, iLoopValue, sValue, element, aNewArray
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize()
		c_sClassName	= "ArrayWrapper"
		c_iClassItems 	= 0
		c_sClassType  	= vbNullString
		Set c_oParent	= Nothing
	End Sub
	Private Sub Class_Terminate()
		'Nothing
	End Sub
	'#---------------------------------------------------------------------------#
	'Class Properties
	Public Property Get Size()
		If IsArray(c_aArray) Then
			Size = c_iClassItems
		End If
	End Property
	Public Property Get oType()
		If IsArray(c_aArray) Then
			oType = c_sClassType
		End If
	End Property
	Public Property Let oType(strType)
		c_sClassType = strType
	End Property
	Public Property Get Data()
		Data = c_aArray
	End Property
	Public Property Get Parent()
		Set Parent = c_oParent
	End Property
	Public Property Let Parent(oParent)
		Set c_oParent = oParent
	End Property
	'#---------------------------------------------------------------------------#
	
	Public Function GetIndexByValue(sStringToTest)
		'**********************************************************************************
		' Purpose : This function loops the array and returns the index depending on weither
		'           or not a string exists as one of the values within the array. 
		' Inputs	: string	: sStringToTest	: string	: the string to check
		' Return	: integer	: the index in the array if found / -1 If Not found
		'****************************************************************************
		'Init vars
		iLoopValue 	= 0
		GetIndexByValue 	= -1
		
		If c_iClassItems > 0 Then
			For Each element In c_aArray
				If IsArray(element) Then
					sValue = element(0)
				Else
					sValue = element
				End If
				
				'cast to string
				sValue = sValue & vbNullString
				sStringToTest = sStringToTest & vbNullString
				
				If LCase(sStringToTest) = LCase(sValue) Then
					GetIndexByValue = iLoopValue + 1
					Exit Function
				End If
				iLoopValue = iLoopValue + 1
			Next
		End If
	End Function
	
	Public Function AddItem(sElement)
		'**********************************************************************************
		' Purpose : This function will Add the specified element to the array
		' Inputs	: string	: sElement	: the string element to add
		' Return	: integer	: OK = True / Error = false
		'**********************************************************************************
		On Error Resume Next
		
		'Detect the not initialized array
		If c_iClassItems = 0 Then
			ReDim c_aArray(0)
			c_aArray(0) = sElement
		Else
			ReDim Preserve c_aArray(c_iClassItems)
			c_aArray(c_iClassItems) = sElement
		End If
		
		c_iClassItems = c_iClassItems + 1
		
		If Err.Number <> 0 Then
			WScript.echo Err.Number & " : " & Err.Description
			AddItem = False
		Else 
			AddItem = True
		End If
		
		'Fire an event
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType, "AddItem", AddItem, sElement
			End If
		End If 
	End Function
	
	Public Function Clear()
		'**********************************************************************************
		' Purpose : This function will Reset the array
		' Inputs	: none
		'**********************************************************************************
		Erase c_aArray 
		c_iClassItems = 0
		
		'Detect Error
		If Err.Number <> 0 Then
			WScript.echo Err.Number & " : " & Err.Description
			Clear = False
		Else 
			Clear = True
		End If
		'clear the error state
		Err.Clear
		
		'Fire an event
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType, "Clear", Clear, vbNullString
			End If
		End If 
	End Function
	
	Public Function UpdateItem(index,sElement)
		'**********************************************************************************
		' Purpose 	: This function will Update the specified element to the array
		' Inputs	: integer 	: index 	: the index to edit
		'			  string	: sElement	: the string element to add
		' Return	: integer	: OK = True / Error = false
		'**********************************************************************************
		'init vars
		UpdateItem = False
		
		'Detect the not initialized array
		If c_iClassItems = 0 Then
			UpdateItem = False
		ElseIf ((index <= (c_iClassItems)) And (index > 0)) Then
			c_aArray(index-1) = sElement
			UpdateItem = True
		End If
		
		'Fire an event
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType,"UpdateItem", UpdateItem, index & ":" & Join(sElement,"|")
			End If
		End If 
	End Function
	
	Public Function DeleteItemByIndex(iElementIndex)
		'**********************************************************************************
		' Purpose 	: This function will delete the specified element from the array
		' Inputs	: integer	: iElementIndex	: the index of the element to delete
		'**********************************************************************************
		'init vars
		aNewArray 			= Empty
		sValue				= Empty
		bFound 				= False
		DeleteItemByIndex 	= False
		iLoopValue 			= 1
		
		iSize = GetSize(c_aArray)
		
		If ((iElementIndex <= (iSize)) And (iElementIndex > 0))Then 
			'extract the array data
			For Each element In c_aArray
				If iLoopValue <> iElementIndex Then
					iSize = GetSize(aNewArray)
					If iSize = 0 Then
						ReDim aNewArray(0) : aNewArray(0) = element 
					Else
						ReDim Preserve aNewArray(iSize) : aNewArray(iSize) = element
					End If
				Else 
					bFound = True
				End If
				iLoopValue = iLoopValue + 1
			Next
			
			'write the data
			If (bFound = True) Then
				iSize = GetSize(aNewArray)
				If (iSize >= 1) Then
					'Set the new values
					ReDim c_aArray(iSize-1)
					
					iLoopValue  = 0
					For Each element In aNewArray
						c_aArray(iLoopValue) = element
						iLoopValue = iLoopValue + 1
					Next
					c_iClassItems = iSize
				Else
					Erase c_aArray
					c_iClassItems = 0
				End If
				DeleteItemByIndex = True
			End If
		End If 
		
		If Err.Number <> 0 Then
			WScript.echo Err.Number & " : " & Err.Description
		End If 
		
		'clear the error state
		Err.Clear
		
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType,"DeleteIndex", DeleteItemByIndex, iElementIndex
			End If
		End If 
	End Function
	
	Public Function DeleteItemByValue(Value,index)
		'**********************************************************************************
		' Purpose : This function will delete the specified element from the array
		' Inputs	: string	: Value	: the string Item to delete
		'			  integer	: index	: the index of array to check	
		' Return	: integer	: OK = True / Error = false
		
		'**********************************************************************************
		'set the default output
		aNewArray 			= Empty
		sValue				= Empty
		bFound 				= False
		DeleteItemByValue 	= False
		iLoopValue 			= 0
		
		'Find the element
		For Each element In c_aArray
			If IsArray(element) Then
				sValue = element(index)
			Else
				sValue = element
			End If	
			
			'cast to string
			sValue 	= sValue & vbNullString
			Value 	= Value & vbNullString	
			
			If LCase(sValue) <> LCase(Value) Then
				iSize = GetSize(aNewArray)
				If iSize = 0 Then
					ReDim aNewArray(0) : aNewArray(0) = element 
				Else
					ReDim Preserve aNewArray(iSize) : aNewArray(iSize) = element
				End If
			Else 
				bfound = True
			End If
		Next
		
		' write the data
		If (bfound = True) Then
			iSize = GetSize(aNewArray)
			If (iSize >= 1) Then
				'Set the new values
				ReDim c_aArray(iSize-1)
				
				iLoopValue = 0
				For Each element In aNewArray
					c_aArray(iLoopValue) = element
					iLoopValue = iLoopValue + 1
				Next
				c_iClassItems = iSize
			Else
				Erase c_aArray
				c_iClassItems = 0
			End If 
			DeleteItemByValue = True
		End If 
		
		If Err.Number <> 0 Then
			WScript.echo Err.Number & " : " & Err.Description
			Err.Clear
		End If 
		
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType,"DeleteItem", DeleteItemByValue, Value
			End If 
		End If 
	End Function
	
	Public Function GetItemByIndex(iElementIndex)
		'**********************************************************************************
		' Purpose : This function will return the specified element from the array
		' Inputs	: integer	: iElementIndex	: the index of the element search for
		'**********************************************************************************
		'init vars
		GetItemByIndex = Empty
		
		If ((iElementIndex <= (c_iClassItems)) And (iElementIndex > 0)) Then
			GetItemByIndex = c_aArray(iElementIndex-1)
		End If
	End Function
	
	Public Function GetItemByValue(ElementValue)
		'**********************************************************************************
		' Purpose : This function will return the specified element from the array
		' Inputs	: integer	: ElementValue	: the value of the element to search for
		'**********************************************************************************
		GetItemByValue = Empty
		
		For Each element In c_aArray
			If IsArray(element) Then
				sValue = element(0)
			Else
				sValue = element
			End If	
			
			'cast to string
			sValue = sValue & vbNullString
			ElementValue = ElementValue & vbNullString	
			
			If (LCase(sValue) = LCase(ElementValue)) Then
				GetItemByValue = element
				Exit Function	
			End If
		Next
	End Function
	
	Private Function GetSize(aArray)
		'#--------------------------------------------------------------------------------#
		' Purpose : Check the array size
		'#--------------------------------------------------------------------------------#	
		On Error Resume Next
		iGetSize = UBound(aArray)
		
		If Err.Number Then
			If ((Err.Number = 9) Or(Err.Number = 13)) Then
				iGetSize = 0
			End If
		Else
			iGetSize = UBound(aArray) + 1
		End If
		On Error Goto 0
		GetSize = iGetSize
	End Function 
	
	Private Function Class_FireEvent (sSource, sEventType, bResult, aValues)
		'#--------------------------------------------------------------------------------#
		' Purpose : Fire an event
		'#--------------------------------------------------------------------------------#	
		If TypeName(c_oParent) <> "Nothing" Then 
			c_oParent.Class_Event sSource, sEventType, bResult, aValues
		End If 
	End Function
End Class

'#################################################################################
' Class Wrapper for RaidenFTPD VFS File
'#################################################################################
Class RaidenVFSFileClass
	'Class vars
	Private	c_sServer,c_sPath, c_sFile, c_bLoaded, c_iCount, c_sFTPDRoot
	Private oFso, oFile
	'Function vars
	Private VFS, item, iCount
	Private aData, aVFSInfo, sLine, ret, aArray
	Private sData, element
	Private bFileExists, bFound
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		c_bLoaded		= False
		c_iCount    	= 0
		c_sPath		 	= vbNullString 
		c_sFile			= vbNullString
		c_sFTPDRoot		= vbNullString
		oFile			= Null
		Set VFS			= New ArrayWrapper
		VFS.oType		= "VFS"
		VFS.Parent		= me
		Set oFso		= CreateObject("Scripting.FileSystemObject")
	End Sub
	Private Sub Class_Terminate
		Set VFS			= Nothing
		Set aData		= Nothing
		Set oFso		= Nothing
		Set oFile		= Nothing
	End Sub
	'#---------------------------------------------------------------------------#
	Public Property Get Server()
		Server = c_sServer
	End Property
	Public Property Let Server(sServer)
		If (VarType(sServer) = vbString) Then
			c_sServer = sServer
		End If 
	End Property
	
	Public Property Get Loaded()
		Loaded = c_bLoaded
	End Property
	Private Property Let Loaded(bLoaded)
		If (VarType(bLoaded) = vbBoolean) Then
			c_bLoaded = bLoaded
		End If 
	End Property
	
	Public Property Get Path()
		Path = c_sPath
	End Property
	Public Property Let Path(sPath)
		If sPath <> vbNullString Then
			c_sPath = sPath
		End If 
	End Property
	
	Public Property Get VFSFile()
		VFSFile = c_sFile
	End Property
	
	Public Property Get Count()
		Count = c_iCount
	End Property
	
	Public Property Get FTPDRoot()
		FTPDRoot = c_sFTPDRoot
	End Property
	'#---------------------------------------------------------------------------#
	
	Public Function Load()
		'**********************************************************************************
		' Puropose : load in memory the Raiden VFS File
		' Input    : None
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:Load"
		On Error Goto 0
		'Init vars
		c_sFile	= c_sPath & "\" & c_sServer & ".vfs"
		c_bLoaded 	= False
		bFileExists = False
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Load VFSFile: " & c_sFile & " Started."

		'check that file exists		
		bFileExists = Helper.FileExists(c_sFile, True)
		
		'Open The file
		Set oFile = oFso.OpenTextFile(c_sFile, FORREADING)
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to read File: " & c_sFile & ". The error was: " & Err.description & " (" & Err.number & ")"
			Helper.Terminate
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & c_sFile & " was successfully opened for read."
		End If
		
		'Read The File
		Do While Not oFile.AtEndOfStream
			sData = oFile.ReadALL
		Loop
		oFile.close
		
		If (Not IsEmpty(sData)) Then
			'split the records
			aData = Split(sData,vbCrLf)
			
			For Each sLine In (aData)
				aVFSInfo = Split(sLine,"|")
				If (IsArray(aVFSInfo) And (UBound(aVFSInfo) = 15) )Then
					'UserLog.LogEvent INFORMATION, "[" & currentSub & "] Processing VFSLine: " & sLine
					'store VFS Data in the VFS Array
					VFS.AddItem(aVFSInfo) 
					
					'Check if this is the FTPD Root Directory
					If (aVFSInfo(1) = "/") Then
						c_sFTPDRoot = aVFSInfo(0)
					End If
				End If
				Helper.EchoErr Err, currentSub
			Next
			'Update the class vars
			c_iCount	= VFS.Size
			c_bLoaded 	= True
			
			Set aData = Nothing
			Set sData = Nothing
			sLine = vbNullString
		End If
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] VFSFile: " & c_sFile & " successfully read and loaded."
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] VFSFile: Loaded VFS Entries:" & c_iCount 
	End Function

	Public Function Save()
		'**********************************************************************************
		' Puropose : Save the VFS in memory to the Raiden VFS File
		' Input    : None
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:Save"	
		
		If 	(c_bLoaded 	= True) Then
				
			Set oFile = oFso.CreateTextFile(c_sFile, True)
			
			If Err.number <> 0 Then
				UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to create output: " & c_sFile & ". The error was : " & Err.description & " (" & Err.number & ")"
				Helper.Terminate
			Else
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & c_sFile & " was successfully created."
				
				'Dump the VFS Content to the file
				For Each element In VFS.Data
					'//TODO
					'//Validation
										
					'Write the line 
					sLine = join(element,"|")
					oFile.WriteLine sLine
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write VFS Line : " & sLine
				Next
				
				'Close the file
				oFile.Close
				
				If Err.number <> 0 Then
					UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to close output: " & c_sFile & ". The error was : " & Err.description & " (" & Err.number & ")"
					Helper.Terminate
				Else
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & c_sFile & " was successfully Closed."
				End If
				
				Set oFile = Nothing	
			End If
		End if
	End Function
	
	Public Function ReadItemByIndex(iIndex)
		'**********************************************************************************
		' Puropose : Read a line Raiden VFS File
		' Input    : iIndex : index of the line
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:ReadLine"
		
		If iIndex <= VFS.Size Then
			ReadItemByIndex = VFS.GetItemByIndex(iIndex)		
		Else
			ReadItemByIndex = vbNullString
		End If 
	End Function
	
	Public Function AddItem(sElement)
		'**********************************************************************************
		' Purpose 	: Add a VFS Entry
		' Inputs	: string	: sElement	: the string element to add
		' Return	: integer	: OK = True / Error = false
		'**********************************************************************************
		
		On Error Resume Next
		 If VFS.AddItem(sElement) = True Then
		 	AddItem = True
		 	'Update the class vars
			c_iCount	= VFS.Size
		Else 
			AddItem = False
		End If
	End Function
	
	Public Function DeleteItemByValue(sStringPath,index)
		'**********************************************************************************
		' Puropose : delete a line in the Raiden VFS File based on the path 
		' Input    : iIndex : index of the line
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:DeleteItemByValue"
		
		If sStringPath <> vbNullString Then
			DeleteItemByValue = VFS.DeleteItemByValue(sStringPath, index)		
		Else
			DeleteItemByValue = False
		End If 
		'Update the class vars
		c_iCount	= VFS.Size
	End Function
	
	Public Function Clean(sMask)
		'**********************************************************************************
		' Puropose : Clean the Raiden VFS File
		' Input    : sMask : the mask to match
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:Clean"
		If Count > 0 Then
			For iCount = 1 To Count
				item = RaidenVFSFile.ReadItemByIndex(iCount)
				If InStr(item(1), sMask) Then
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] : Found match " & Join(item,"|")
				End if
			Next
		End If 
	End function
	
	Public Function GetRealObject (sVirtualPath, sItem)
		'********************************************************************************
		' Purpose : Return the Real path matching the  virtual Path
		' Input   : String 	: sVirtualPath	: The sVirtualPath to check
		'         : Integer	: sItem		    : The item to find (dir or file)
		' Return  : String	: The resolved real Folder or File
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:GetRealObject" 
		
		Dim sLine, sPaths, iPathLen, iNewPathLen, sPathElement, sRemainPath, oFound, sFind, sFullpath, sExt
	
		GetRealObject = vbNullString 
		oFound        = null
		'Get the current VFS Line
		If (RaidenVFSFile.Count > 0) Then
			iPathLen = 0
			For Each element In VFS.Data
				'Extract the Section Data
				sLine = element(1)
				If InStr(LCase(sVirtualPath), LCase(sLine)) > 0 Then
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Match Found " & sLine
					'Need to find the longest path match
					iNewPathLen = Len(sLine)
					If ( iNewPathLen > iPathLen )Then
						iPathLen = iNewPathLen
						'Extract the Path Data
						sRemainPath = replace(Replace(sVirtualPath,sLine,vbNullString), "/","\")
						sPaths = element(0)
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] * Path Selected " & sLine
					Else
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] * Path NOT Selected " & sLine
					End if 
				End If 
			Next
		End If 
		
		'process the paths	
		For Each sPathElement In Split(sPaths,";")
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Checking Path " & sPathElement & sRemainPath
			sFullpath = sPathElement & sRemainPath & "\"&  sItem
			if oFso.FolderExists(sFullpath)  Then
				Set oFound = oFso.GetFolder(sFullpath)
				sFind = "Folder"
				sExt  = vbNullString
			Else
				If oFso.FileExists(sFullpath) Then
					Set oFound = oFso.GetFile(sFullpath)
					sFind = "File"
					sExt  = Right(oFound.Name,Len(oFound.Name) - InStrRev(oFound.Name,".")+1)
				End If 
			End If 
			
			If Not(IsNull(oFound)) Then
				GetRealObject = Split(oFound.ParentFolder.Path & "|" & oFound.Name & "|" & sFind & "|" & sExt,"|")
				UserLog.LogEvent SUCCESS, "[" & currentSub & "] Found " & sFind & " in '" & oFound & "'"
				Exit Function
			Else 
				GetRealObject = Array()
			End If
		Next 
		UserLog.LogEvent ERRORL, "[" & currentSub & "] Unable to find '" & sItem & "'"
	End Function
	
	Public Function GetSectionFromPath (sVirtualPath, ISecLevel)
		'********************************************************************************
		' Purpose : Return The Section matching the  virtual dir/file name
		' Input   : String 	: sVirtualPath		: The sVirtualPath to check
		'         : Integer	: ISecLevel		    : The Level For Section
		' Return  : String	: the Section Name found or vbnullString if not found
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:GetSectionFromPath" 
		
		Dim sLine
		'Get the current VFS Line
		If (RaidenVFSFile.Count > 0) Then
			For Each element In VFS.Data
									
				'Extract the Section Data
				sLine = element(1)
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Checking Section " & sLine
				
				If (sLine = "/") Then
					'This is the Root so not a section
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Root Folder (Not a Section) " & sLine
				ElseIf (InStr(LCase(sLine),"/" & LCase(DIR_NAME))) Then 
					'This is one of the Script VFS Entry so not a section
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Script VFS Entry (Not a Section) " & sLine
				ElseIf (InStr(LCase(sVirtualPath), LCase(sLine))) Then  
					'This should be a section
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Processing VFS Entry (Possibly a Section) " & sLine
					'Extract the Section
					aArray = Split(sLine,"/")
					If (UBound(aArray) > ISecLevel -1) Then
						GetSectionFromPath = aArray(ISecLevel)
						UserLog.LogEvent SUCCESS, "[" & currentSub & "] Matched Section (level:" & ISecLevel & "): " & GetSectionFromPath
						Exit for
					Else
						'Ends here if no match found
						GetSectionFromPath = "DEFAULT"
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] No Match Found using default section (level:" & ISecLevel & "): " & GetSectionFromPath
					End If 
				Else
					'Ends here if no match found
					GetSectionFromPath = "DEFAULT"
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] No Match Found using default section (level:" & ISecLevel & "): " & GetSectionFromPath	
				End If
			Next
		Else 
			 GetSectionFromPath = vbNullString
		End If
	End Function

	Public Sub Class_Event(sSource, sEventType, ByVal bResult,ByVal values)
		'********************************************************************************
		' Purpose : Fire an event received from the child objects
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFileClass:Class_Event"
		
		If IsArray(values) Then
			values = Join(values,"|")
		End If 
		
		If (TypeName(DEBUG_CLASS_EVENTS) <> "Nothing") Then
			If (DEBUG_CLASS_EVENTS = True) Then
				WScript.Echo "EVENT FIRED [" & currentSub & "] source: " & sSource & " ; EventType:" & sEventType & " ; Result:" & bResult & " ; values:" & values
			End If
		End If 
	End Sub
End Class

'######################################################################################
' Class Wrapper for RaidenFTPD Command Output File
'######################################################################################
Class RaidenOutFileClass
	
	'local vars
	Private sUserFile
	Private	oFile,oFso,oOut
	Private	sStr, sLine, sTmpStr  	
	Private ilength,iStrLength,ilenth1,ilenth2
	Private aMultiLineMsg
	'class vars
	Private c_sServer, c_sDestUser, c_iWidth, c_bSceneView, c_bOutputResult, c_sFilePath, c_sGCID, c_sCmdType
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		c_bOutputResult	= True
		c_bSceneView	= True
		c_sFilePath 	= vbNullString
		c_sGCID 		= vbNullString
		c_sServer 		= vbNullString
		c_sDestUser		= vbNullString
		c_sCmdType		= "Command"
		c_iWidth		= 71
		Set oFile		= Nothing
		Set oOut		= Nothing
		Set oFso		= CreateObject("Scripting.FileSystemObject")
	End Sub
	
	Private Sub Class_Terminate
		Set oFso	= Nothing
		Set oFile	= Nothing
		Set oOut	= Nothing
	End Sub
	'#---------------------------------------------------------------------------#
	Public Property Get Path()
		Path = c_sFilePath
	End Property
	Public Property Let Path(sPath)
		If sPath <> vbNullString Then
			c_sFilePath = sPath
		End If 
	End Property
	
	Public Property Get Width()
		Width = c_iWidth
	End Property
	Public Property Let Width(iWidth)
		c_iWidth = iWidth
	End Property
	
	Public Property Get SceneView()
		SceneView = c_bSceneView
	End Property
	Public Property Let SceneView(bSceneView)
		c_bSceneView = bSceneView
	End Property
	
	Public Property Get Result()
		Result = c_bOutputResult
	End Property
	Public Property Get UserFile()
		UserFile = sUserFile
	End Property
	
	Public Property Let Result(bOutputResult)
		If TypeName(bOutputResult) = vbBoolean Then
			c_bOutputResult = bOutputResult
		End If 
	End Property
	
	Public Property Get GCID()
		GCID = c_sGCID
	End Property
	Public Property Let GCID(sGCID)
		If sGCID <> vbNullString Then
			c_sGCID = sGCID
		End If 
	End Property
	
	Public Property Get Server()
		Server = c_sServer
	End Property
	Public Property Let Server(sServer)
		If (VarType(sServer) = vbString) Then
			c_sServer = sServer
		End If 
	End Property
	
	Public Property Get DestUser()
		DestUser = c_sDestUser
	End Property
	Public Property Let DestUser(sDestUser)
		If (VarType(sDestUser) = vbString) Then
			c_sDestUser = sDestUser
		End If 
	End Property
	
	Public Property Get CmdType()
		CmdType = c_sCmdType
	End Property
	Public Property Let CmdType(sCmdType)
		If sCmdType <> vbNullString Then
			c_sCmdType = sCmdType
			Set oOut = Nothing
		End If 
	End Property	
	'#---------------------------------------------------------------------------#
	
	Public Sub Initialize()
		'********************************************************************************
		' Purpose : Create an FTPD reply (Output file) as an object oOut
		' Input   : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:Initialize"
		
		'On Error Resume Next
		Err.clear
		
		If (LCase(CmdType) = "login" Or  LCase(CmdType) = "command") Then
			sUserFile = c_sFilePath & "\OutPut" & "\ask-onSite" & c_sCmdType & "." & c_sGCID
		Else 
			If LCase(CmdType) = "notify" Then
				sUserFile = Path & "\Message" & "\site-Message-" & Server & "-" & DestUser & ".msg"
			End If
		End If 
		
		Set oOut = oFso.CreateTextFile(sUserFile, True)
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to create output: " & UserFile & ". The error was : " & Err.description & " (" & Err.number & ")"
			CmdProcessor.TerminateInSysErr
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & UserFile & " was successfully created."
		End If
	End Sub	
	
	Public function ReadOutput(bExcludeOutputResult)
		'********************************************************************************
		' Purpose : Read the last FTPD reply (Output file)
		' Input   : bEXcludeOutputResult : include or not the first line
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:ReadOutput"
		
		'On Error Resume Next
		Err.clear
		
		If (LCase(CmdType) = "login" Or  LCase(CmdType) = "command") Then
			sUserFile = c_sFilePath & "\OutPut" & "\ask-onSite" & c_sCmdType & "." & c_sGCID
		Else 
			If LCase(CmdType) = "notify" Then
				sUserFile = Path & "\Message" & "\site-Message-" & Server & "-" & DestUser & ".msg"
			End If
		End If 
		
		If Helper.FileExists(sUserFile,False) Then
			with oFso.OpenTextFile(sUserFile,1)
				If bExcludeOutputResult = True Then
					.SkipLine
				End if
				ReadOutput = .ReadAll
			End with
			'Just logging
			'UserLog.LogEvent INFORMATION, "[" & currentSub & "] Read Output: "
			'UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & ReadOutput
		End if		
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to Read File: " & sUserFile & ". The error was: " & Err.description & " (" & Err.number & ")"
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & UserFile & " was successfully read."
		End If
	End Function 
	
	Sub WriteResultOnly()
		'********************************************************************************
		' Puropose : Write the common intro of every user reply
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteResultOnly"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If (c_bOutputResult = True) Then 
			oOut.WriteLine "1"
		Else 
			oOut.WriteLine "0"
		End If
		
		Close
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Result : " & c_bOutputResult
	End Sub
	
	Sub WriteMsgHeader()
		'********************************************************************************
		' Puropose : Write the common intro of every user reply
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgHeader"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If (c_bOutputResult = True) Then 
			oOut.WriteLine "1"
		Else 
			oOut.WriteLine "0"
		End If
		
		If c_bSceneView Then
			sStr = SCENEHEADER
		Else
			sStr = NORMALHEADER
		End If
		If (sStr <> vbNullString) Then
			oOut.WriteLine sStr
		End If
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message Header."
	End Sub
	
	Sub WriteMsgHeaderNoResult()
		'********************************************************************************
		' Puropose : Write the common intro of every user reply
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgHeaderNoResult"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If c_bSceneView Then
			sStr = SCENEHEADER
		Else
			sStr = NORMALHEADER
		End If
		If (sStr <> vbNullString) Then
			oOut.WriteLine sStr
		End If
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message Header No Result."
	End Sub
	
	Sub WriteMsgSeperator()
		'********************************************************************************
		' Purpose : Build up a Formated Seperator string
		' Input   : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgSeperator"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 	
		
		If c_bSceneView Then
			sStr = SCENESEPARATOR
		Else
			sStr = NORMALSEPARATOR
		End If
		If (sStr <> vbNullString) Then
			oOut.WriteLine sStr
		End If
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message Seperator"
	End Sub
	
	Sub WriteMsgTail(bIncludeDate)
		'********************************************************************************
		' Puropose : Write the common last lines of every user reply
		' Input    : bIncludeDate : option to include date in the footre
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgTail"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If c_bSceneView Then
			sStr = SCENETAIL
		Else
			sStr = NORMALTAIL
		End If
		
		If (bIncludeDate) And (Len(sStr) > Len(Date) +3) Then
			sStr = Left(sStr, Len(sStr) - Len(Date) -5) & "-" &  Date & "-" & Right(sStr, 3)
		End If 
		
		If (sStr <> vbNullString) Then
			oOut.WriteLine sStr
		End If
		
		Close
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message Tail"
	End Sub
	
	Sub Close()
		'********************************************************************************
		' Puropose : Write the common last lines of every user reply
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:Close"
		
		oOut.Close
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to close output: " & UserFile & ". The error was : " & Err.description & " (" & Err.number & ")"
			CmdProcessor.TerminateInSysErr
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & UserFile & " was successfully Closed."
		End If
		
		Set oOut = Nothing
	End Sub
	
	Sub WriteMsg (sMessage, iPreSpace)
		'********************************************************************************
		' Purpose : Build and Write a Formated string
		' Input   : string  : sMessage	    : the input string
		'			integer : preSpace	: the desired pre spaces to insert
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsg"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If c_bSceneView Then
			aMultiLineMsg = Helper.BreakString(sMessage,vbNullString,c_iWidth - iPreSpace - 3,True)
			For Each sLine In aMultiLineMsg
				sTmpStr = "|" & Space(iPreSpace) & sLine
				sTmpStr = Helper.BuildString(sTmpStr,(c_iWidth-1)) & "|"
				oOut.WriteLine sTmpStr
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message : " & sTmpStr
			Next
		Else
			aMultiLineMsg = Helper.BreakString(sMessage,vbNullString,c_iWidth - iPreSpace + 1,False)
			For Each sLine In aMultiLineMsg
				sTmpStr = Space(iPreSpace) & sLine
				oOut.WriteLine sTmpStr
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message : " & sTmpStr
			Next
		End If
	End Sub
	
	Sub WriteMsgWithAppend (ByVal sMessage, ByVal sMessage2, iPreSpace)
		'********************************************************************************
		' Purpose : Build and write a Formated string
		' Input   : string  : sMessage	    : the input string
		'			string  : sMessage2		: the string to append
		'			integer : iPreSpace	: the desired pre spaces to insert
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgWithAppend"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If c_bSceneView Then
			aMultiLineMsg = Helper.BreakString(sMessage,sMessage2,c_iWidth - iPreSpace - 3,True)
			For Each sLine In aMultiLineMsg
				sTmpStr = "|" & Space(iPreSpace) & sLine
				sTmpStr = Helper.BuildString(sTmpStr,(c_iWidth-1)) & "|"
				oOut.WriteLine sTmpStr
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message : " & sTmpStr
			Next
		Else
			aMultiLineMsg = Helper.BreakString(sMessage,sMessage2,c_iWidth - iPreSpace + 1,False)
			For Each sLine In aMultiLineMsg
				sTmpStr = Space(iPreSpace) & sLine
				oOut.WriteLine sTmpStr
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message : " & sTmpStr
			Next
		End If
	End Sub
End Class

Public Sub Class_Event(sSource, sEventType,ByVal bResult,ByVal values)
	'********************************************************************************
	' Purpose : Fire an event received from the child objects
	'********************************************************************************
	Dim currentSub : currentSub = "Main:Class_Event"
	
	If IsArray(values) Then
		values = Join(values,"|")
	ElseIf (values = vbNullString) Then
		values = "Null"
	End If 
	
	If (TypeName(DEBUG_CLASS_EVENTS) <> "Nothing") Then
		If (DEBUG_CLASS_EVENTS = True) Then
			WScript.Echo "EVENT FIRED [" & currentSub & "] source: " & sSource & " ; EventType:" & sEventType & " ; Result:" & bResult & " ; values:" & values
		End If
	End If 
End Sub

Sub Import (sFileName)
	'**********************************************************************************
	' Purpose : Import external file
	'**********************************************************************************
	Dim oFso, oFile
	Dim sScriptDir, sFilePath, sStreamData
	
	Set oFso		= CreateObject("Scripting.FileSystemObject")
	sScriptDir = oFso.GetParentFolderName(WScript.ScriptFullName)   
	sFilePath = oFso.BuildPath(sScriptDir,sFileName)   
	Const ForReading = 1   
	
	Set oFile = oFso.OpenTextFile(sFilePath,ForReading)   
	sStreamData = oFile.ReadAll()   
	ExecuteGlobal sStreamData   
End Sub